/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.errors;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.libs.org.parboiled.common.Formatter;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.errors.ErrorUtils;
import lombok.ast.libs.org.parboiled.errors.InvalidInputError;
import lombok.ast.libs.org.parboiled.matchers.CharSetMatcher;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.support.MatcherPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInvalidInputErrorFormatter<V>
implements Formatter<InvalidInputError<V>> {
    @Override
    public String format(InvalidInputError<V> error) {
        if (error == null) {
            return "";
        }
        String errorMessage = String.format("Invalid input '%s%s'", StringUtils.escape(String.valueOf(error.getInputBuffer().charAt(error.getStartIndex()))), error.getEndIndex() - error.getStartIndex() > 1 ? "..." : "");
        String expectedString = this.getExpectedString(error);
        return StringUtils.isEmpty(expectedString) ? errorMessage : errorMessage + ", expected " + expectedString;
    }

    public String getExpectedString(InvalidInputError<V> error) {
        ArrayList<String> labelList = new ArrayList<String>();
        for (MatcherPath<V> path : error.getFailedMatchers()) {
            String[] labels;
            Matcher<V> labelMatcher = ErrorUtils.findProperLabelMatcher(path, error.getLastMatch());
            if (labelMatcher == null) continue;
            for (String label : labels = this.getLabels(labelMatcher)) {
                if (label == null || labelList.contains(label)) continue;
                labelList.add(label);
            }
        }
        return this.join(labelList);
    }

    public String[] getLabels(Matcher<V> matcher) {
        if (matcher instanceof CharSetMatcher) {
            CharSetMatcher cMatcher = (CharSetMatcher)matcher;
            if (!cMatcher.characters.isSubtractive()) {
                String[] labels = new String[cMatcher.characters.getChars().length];
                for (int i = 0; i < labels.length; ++i) {
                    labels[i] = '\'' + String.valueOf(cMatcher.characters.getChars()[i]) + '\'';
                }
                return labels;
            }
        }
        return new String[]{matcher.getLabel()};
    }

    public String join(List<String> labelList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < labelList.size(); ++i) {
            if (i > 0) {
                sb.append(i < labelList.size() - 1 ? ", " : " or ");
            }
            sb.append(labelList.get(i));
        }
        return StringUtils.escape(sb.toString());
    }
}

