/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Case
extends AbstractNode
implements Statement {
    private AbstractNode condition = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astCondition() {
        if (!(this.condition instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.condition);
    }

    public Case astCondition(Expression condition) {
        if (condition == null) {
            throw new NullPointerException("condition is mandatory");
        }
        return this.rawCondition(condition);
    }

    public Node rawCondition() {
        return this.condition;
    }

    public Case rawCondition(Node condition) {
        if (condition == this.condition) {
            return this;
        }
        if (condition != null) {
            this.adopt((AbstractNode)condition);
        }
        if (this.condition != null) {
            this.disown(this.condition);
        }
        this.condition = (AbstractNode)condition;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.condition != null) {
            result.add(this.condition);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.condition == original) {
            this.rawCondition(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.condition == child) {
            this.disown((AbstractNode)child);
            this.condition = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitCase(this)) {
            return;
        }
        if (this.condition != null) {
            this.condition.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Case copy() {
        Case result = new Case();
        if (this.condition != null) {
            result.rawCondition(this.condition.copy());
        }
        return result;
    }
}

