/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.ResourceItem;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DataFile<I extends DataItem> {
    private final FileType mType;
    protected File mFile;
    private final Map<String, I> mItems = Maps.newHashMap();

    DataFile(@NonNull File file, FileType fileType) {
        this.mType = fileType;
        this.mFile = file;
    }

    protected final void init(@NonNull I item) {
        ((DataItem)item).setSource((DataFile)this);
        this.mItems.put(((DataItem)item).getKey(), item);
    }

    protected void init(@NonNull Iterable<I> items) {
        for (DataItem item : items) {
            item.setSource(this);
            this.mItems.put(item.getKey(), item);
        }
    }

    @NonNull
    FileType getType() {
        return this.mType;
    }

    @NonNull
    public File getFile() {
        return this.mFile;
    }

    I getItem() {
        assert (this.mItems.size() == 1);
        return (I)((DataItem)this.mItems.values().iterator().next());
    }

    boolean hasNotRemovedItems() {
        for (DataItem item : this.mItems.values()) {
            if (item.isRemoved()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public Collection<I> getItems() {
        return this.mItems.values();
    }

    @NonNull
    public Map<String, I> getItemMap() {
        return this.mItems;
    }

    public void addItems(@NonNull Collection<I> items) {
        for (DataItem item : items) {
            item.setSource(this);
            this.mItems.put(item.getKey(), item);
        }
    }

    public void removeItems(@NonNull Collection<I> items) {
        for (DataItem item : items) {
            this.mItems.remove(item.getKey());
            item.setSource(null);
        }
    }

    public void removeItem(ResourceItem item) {
        this.mItems.remove(item.getKey());
        item.setSource(null);
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    public void replace(@NonNull I oldItem, @NonNull I newItem) {
        this.mItems.remove(((DataItem)oldItem).getKey());
        ((DataItem)oldItem).setSource(null);
        ((DataItem)newItem).setSource((DataFile)this);
        this.mItems.put(((DataItem)newItem).getKey(), newItem);
    }

    public String toString() {
        return "DataFile{mFile=" + this.mFile + '}';
    }

    static enum FileType {
        SINGLE,
        MULTI;

    }
}

