/*
RSSBar.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "RSSBar.h"

@implementation RSSBar

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)awakeFromNib
{
    NSRect  bounds, frame;
    bounds = [self bounds];
    
    // Add RSS symbol image
    NSImage*        symbolImage;
    NSImageView*    symbolImageView;
    symbolImage = [NSImage imageNamed:@"rssSymbol"];
    frame.origin.x = 10;
    frame.origin.y = 8;
    frame.size = [symbolImage size];
    symbolImageView = [[NSImageView alloc] initWithFrame:frame];
    [symbolImageView setImage:symbolImage];
    [self addSubview:symbolImageView];
    [symbolImageView release];
}

- (void)dealloc
{
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Attributes --
//--------------------------------------------------------------//

- (NSString*)title
{
    return [_attrTitle string];
}

- (void)setTitle:(NSString*)title
{
    [_attrTitle release], _attrTitle = nil;
    if (!title) {
        return;
    }
    
    static NSDictionary*    _attrs = nil;
    if (!_attrs) {
        NSShadow*   shadow;
        shadow = [[NSShadow alloc] init];
        [shadow setShadowColor:[NSColor blackColor]];
        [shadow setShadowOffset:NSMakeSize(0, -1)];
        [shadow setShadowBlurRadius:0.0f];
        
        _attrs = [[NSDictionary dictionaryWithObjectsAndKeys:
                [NSColor whiteColor], NSForegroundColorAttributeName, 
                [NSFont boldSystemFontOfSize:13.0f], NSFontAttributeName, 
                nil] retain];
        [shadow release];
    }
    
    // Create attributed title
    _attrTitle = [[NSAttributedString alloc] 
            initWithString:title attributes:_attrs];
    
    // Update itself
    [self setNeedsDisplay:YES];
}

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (void)drawRect:(NSRect)rect
{
    // Get bounds
    NSRect  bounds;
    bounds = [self bounds];
    
    // Get background image
    NSImage*    image;
    image = [NSImage imageNamed:@"shelfBarOcean"];
    
    // Draw background image
    NSRect  srcRect, destRect;
    srcRect.origin = NSZeroPoint;
    srcRect.size = [image size];
    destRect = bounds;
    [image drawInRect:destRect fromRect:srcRect operation:NSCompositeCopy fraction:1.0f];
    
    // Draw title
    if (_attrTitle) {
        NSSize  size;
        NSRect  rect;
        size = [_attrTitle size];
        rect.origin.x = 30;
        rect.origin.y = (bounds.size.height - size.height) / 2.0f;
        rect.size.width = bounds.size.width - rect.origin.x - 60;
        rect.size.height = size.height;
        [_attrTitle drawInRect:rect];
    }
}

@end
