/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import org.newsclub.net.unix.AFUNIXCore;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.NativeUnixSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXPipe
extends Pipe
implements Closeable {
    private final AFUNIXCore sourceCore = new AFUNIXCore(this, null);
    private final AFUNIXCore sinkCore = new AFUNIXCore(this, null);
    private final SourceChannel sourceChannel;
    private final SinkChannel sinkChannel;
    private final int options;

    AFUNIXPipe(AFUNIXSelectorProvider provider, boolean selectable) throws IOException {
        boolean isSocket = NativeUnixSocket.initPipe(this.sourceCore.fd, this.sinkCore.fd, selectable);
        this.options = isSocket ? 0 : 8;
        this.sourceChannel = new SourceChannel(provider);
        this.sinkChannel = new SinkChannel(provider);
    }

    public static AFUNIXPipe open() throws IOException {
        return AFUNIXSelectorProvider.provider().openPipe();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SourceChannel source() {
        return this.sourceChannel;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SinkChannel sink() {
        return this.sinkChannel;
    }

    FileDescriptor sourceFD() {
        return this.sourceCore.fd;
    }

    FileDescriptor sinkFD() {
        return this.sinkCore.fd;
    }

    @Override
    public void close() throws IOException {
        try {
            this.source().close();
        }
        finally {
            this.sink().close();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public final class SinkChannel
    extends Pipe.SinkChannel
    implements FileDescriptorAccess {
        private SinkChannel(SelectorProvider provider) {
            super(provider);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (length == 0) {
                return 0L;
            }
            return this.write(srcs[offset]);
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return AFUNIXPipe.this.sinkCore.write(src, null, AFUNIXPipe.this.options);
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
            AFUNIXPipe.this.sinkCore.implConfigureBlocking(block);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            AFUNIXPipe.this.sinkCore.close();
        }

        @Override
        public FileDescriptor getFileDescriptor() throws IOException {
            return ((AFUNIXPipe)AFUNIXPipe.this).sinkCore.fd;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public final class SourceChannel
    extends Pipe.SourceChannel
    implements FileDescriptorAccess {
        private SourceChannel(SelectorProvider provider) {
            super(provider);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (length == 0) {
                return 0L;
            }
            return this.read(dsts[offset]);
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return AFUNIXPipe.this.sourceCore.read(dst, null, AFUNIXPipe.this.options);
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
            AFUNIXPipe.this.sourceCore.implConfigureBlocking(block);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            AFUNIXPipe.this.sourceCore.close();
        }

        @Override
        public FileDescriptor getFileDescriptor() throws IOException {
            return ((AFUNIXPipe)AFUNIXPipe.this).sourceCore.fd;
        }
    }
}

