/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.stardict;

import io.github.eb4j.stardict.DictionaryData;
import io.github.eb4j.stardict.DictionaryDataBuilder;
import io.github.eb4j.stardict.IndexEntry;
import io.github.eb4j.stardict.StarDictDictionary;
import io.github.eb4j.stardict.StarDictFileDict;
import io.github.eb4j.stardict.StarDictInfo;
import io.github.eb4j.stardict.StarDictZipDict;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public final class StarDictLoader {
    private StarDictLoader() {
    }

    public static StarDictDictionary load(File ifoFile, int cacheSize) throws Exception {
        String bitsString;
        Map<String, String> header = StarDictLoader.readIFO(ifoFile);
        StarDictInfo info = new StarDictInfo(header);
        String version = info.getVersion();
        if (!"2.4.2".equals(version) && !"3.0.0".equals(version)) {
            throw new Exception("Invalid version of dictionary: " + version);
        }
        StarDictDictionary.EntryType[] types = null;
        String sametypesequence = header.get("sametypesequence");
        if (sametypesequence != null) {
            types = new StarDictDictionary.EntryType[sametypesequence.length()];
            for (int i = 0; i < sametypesequence.length(); ++i) {
                types[i] = StarDictDictionary.EntryType.getTypeByValue(sametypesequence.charAt(i));
                if (types[i] != null) continue;
                throw new Exception("Invalid dictionary type: " + sametypesequence);
            }
        }
        int idxoffsetbits = 32;
        if ("3.0.0".equals(version) && (bitsString = header.get("idxoffsetbits")) != null) {
            idxoffsetbits = Integer.parseInt(bitsString);
        }
        if (idxoffsetbits != 32 && idxoffsetbits != 64) {
            throw new Exception("StarDict dictionaries other than idxoffsetbits=64 or 32 are not supported.");
        }
        String f = ifoFile.getPath();
        if (f.endsWith(".ifo")) {
            f = f.substring(0, f.length() - ".ifo".length());
        }
        String dictName = f;
        File idxFile = StarDictLoader.getFile(dictName, ".idx.gz", ".idx").orElseThrow(() -> new FileNotFoundException("No .idx file could be found"));
        File synFile = StarDictLoader.getFile(dictName, ".syn.gz", ".syn").orElse(null);
        DictionaryData<IndexEntry> data = StarDictLoader.loadData(idxFile, synFile, idxoffsetbits == 64, types);
        File dictFile = StarDictLoader.getFile(dictName, ".dict.dz", ".dict").orElseThrow(() -> new FileNotFoundException("No .dict.dz or .dict files were found for " + dictName));
        try {
            if (dictFile.getName().endsWith(".dz")) {
                return new StarDictZipDict(info, dictFile, data, cacheSize);
            }
            return new StarDictFileDict(info, dictFile, data, cacheSize);
        }
        catch (IOException ex) {
            throw new FileNotFoundException("No .dict.dz or .dict files were found for " + dictName);
        }
    }

    private static Map<String, String> readIFO(File ifoFile) throws Exception {
        TreeMap<String, String> result = new TreeMap<String, String>();
        try (BufferedReader rd = Files.newBufferedReader(ifoFile.toPath(), StandardCharsets.UTF_8);){
            String line;
            String first = rd.readLine();
            if (!"StarDict's dict ifo file".equals(first)) {
                throw new Exception("Invalid header of .ifo file: " + first);
            }
            while ((line = rd.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                int pos = line.indexOf(61);
                if (pos < 0) {
                    throw new Exception("Invalid format of .ifo file: " + line);
                }
                result.put(line.substring(0, pos), line.substring(pos + 1));
            }
        }
        return result;
    }

    private static Optional<File> getFile(String basename, String ... suffixes) {
        return Stream.of(suffixes).map(suff -> new File(basename + suff)).filter(File::isFile).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DictionaryData<IndexEntry> loadData(File idxFile, File synFile, boolean off64, StarDictDictionary.EntryType[] types) throws IOException {
        int b;
        Throwable throwable;
        ByteArrayOutputStream mem2;
        Throwable throwable2;
        DictionaryDataBuilder builder = new DictionaryDataBuilder();
        try (InputStream is = Files.newInputStream(idxFile.toPath(), new OpenOption[0]);){
            if (idxFile.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is, 8192);
            }
            throwable2 = null;
            try (DataInputStream idx = new DataInputStream(new BufferedInputStream(is));){
                mem2 = new ByteArrayOutputStream();
                throwable = null;
                try {
                    int c = 0;
                    StarDictDictionary.EntryType type = null;
                    while (true) {
                        if (types != null) {
                            type = types[c %= types.length];
                        }
                        if ((b = idx.read()) == -1) {
                            break;
                        }
                        if (b == 0) {
                            String key = new String(mem2.toByteArray(), 0, mem2.size(), StandardCharsets.UTF_8);
                            mem2.reset();
                            long bodyOffset = off64 ? idx.readLong() : (long)idx.readInt();
                            int bodyLength = idx.readInt();
                            builder.add(key, new IndexEntry(bodyOffset, bodyLength, type));
                            ++c;
                            continue;
                        }
                        mem2.write(b);
                    }
                }
                catch (Throwable c) {
                    throwable = c;
                    throw c;
                }
                finally {
                    if (mem2 != null) {
                        if (throwable != null) {
                            try {
                                mem2.close();
                            }
                            catch (Throwable c) {
                                throwable.addSuppressed(c);
                            }
                        } else {
                            mem2.close();
                        }
                    }
                }
            }
            catch (Throwable mem2) {
                throwable2 = mem2;
                throw mem2;
            }
        }
        if (synFile == null) {
            return builder.build();
        }
        is = Files.newInputStream(synFile.toPath(), new OpenOption[0]);
        try {
            if (synFile.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is, 8192);
            }
            throwable2 = null;
            try (DataInputStream syn = new DataInputStream(new BufferedInputStream(is));){
                mem2 = new ByteArrayOutputStream();
                throwable = null;
                try {
                    while ((b = syn.read()) != -1) {
                        if (b == 0) {
                            String key = new String(mem2.toByteArray(), 0, mem2.size(), StandardCharsets.UTF_8);
                            mem2.reset();
                            int index = syn.readInt();
                            builder.addSynonym(key, index);
                            continue;
                        }
                        mem2.write(b);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (mem2 != null) {
                        if (throwable != null) {
                            try {
                                mem2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            mem2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        finally {
            is.close();
        }
        return builder.build();
    }
}

