/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.MenuItemPager;

public class TransTipsPopup
implements IPopupMenuConstructor {
    @Override
    public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        if (!Core.getEditor().getSettings().isMarkGlossaryMatches()) {
            return;
        }
        if (!isInActiveEntry || isInActiveTranslation) {
            return;
        }
        int startSource = sb.getStartSourcePosition();
        int len = sb.getSourceText().length();
        if (mousepos < startSource || mousepos > startSource + len) {
            return;
        }
        MenuItemPager pager = new MenuItemPager(menu);
        HashSet<String> added = new HashSet<String>();
        for (final GlossaryEntry ge : GlossaryTextArea.nowEntries) {
            for (Token[] toks : Core.getGlossaryManager().searchSourceMatchTokens(sb.getSourceTextEntry(), ge)) {
                for (Token tok : toks) {
                    if (startSource + tok.getOffset() > mousepos || mousepos > startSource + tok.getOffset() + tok.getLength()) continue;
                    for (String s : ge.getLocTerms(true)) {
                        if (added.contains(s)) continue;
                        final JMenuItem it = pager.add(new JMenuItem(s));
                        it.addActionListener(e -> Core.getEditor().insertText(s));
                        it.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseEntered(MouseEvent e) {
                                String comment = ge.getCommentText();
                                if (!StringUtil.isEmpty(comment)) {
                                    it.setToolTipText(comment);
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                if (it.getToolTipText(e) != null) {
                                    it.setToolTipText(null);
                                }
                            }
                        });
                        added.add(s);
                    }
                }
            }
        }
        menu.addSeparator();
    }
}

