/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.chartable;

import java.awt.Color;
import java.awt.Point;
import javax.swing.table.DefaultTableCellRenderer;
import org.omegat.gui.editor.autocompleter.AutoCompleterTableView;
import org.omegat.gui.editor.chartable.CharTableModel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class CharTableAutoCompleterView
extends AutoCompleterTableView {
    private CharTableModel model = new CharTableModel(null);
    DefaultTableCellRenderer renderer;

    public CharTableAutoCompleterView() {
        super(OStrings.getString("AC_CHARTABLE_VIEW"));
        this.getTable().setModel(this.model);
        this.getTable().setShowGrid(true);
        this.getTable().setGridColor(Color.gray);
        this.renderer = (DefaultTableCellRenderer)this.getTable().getDefaultRenderer(this.getTable().getColumnClass(0));
        this.renderer.setHorizontalAlignment(0);
        this.setSelection(new Point(0, 0));
    }

    @Override
    public void updateViewData() {
        this.updateModel();
    }

    public void updateModel() {
        String customChars;
        String input = null;
        if (Preferences.isPreference("ac_chartable_use_custom_chars") && !(customChars = Preferences.getPreference("ac_chartable_custom_char_string")).isEmpty()) {
            input = customChars;
        }
        if (this.model.setData(input)) {
            this.setSelection(new Point(0, 0));
        }
    }

    @Override
    public void setSelection(Point p) {
        super.setSelection(this.model.modifyPoint(p));
    }

    @Override
    public boolean shouldPopUp() {
        return false;
    }

    @Override
    protected boolean isEnabled() {
        return Preferences.isPreferenceDefault("ac_chartable_enabled", true);
    }
}

