/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.statistics.StatisticsSettings;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.XMLReader;
import org.omegat.filters3.xml.XMLWriter;

public abstract class AbstractXmlFilter
extends AbstractFilter {
    private String encoding;
    private String eol;
    protected XMLInputFactory iFactory;
    protected XMLOutputFactory oFactory;
    protected boolean isEventMode = false;
    protected Map<String, List<XMLEvent>> tagsMap = new TreeMap<String, List<XMLEvent>>();
    protected static final Pattern OMEGAT_TAG = Pattern.compile("<(\\/?)([a-z]\\d+)\\/?>");
    protected static final XMLEventFactory eFactory = XMLEventFactory.newInstance();

    public AbstractXmlFilter() {
        this.iFactory = XMLInputFactory.newInstance();
        this.oFactory = XMLOutputFactory.newInstance();
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public BufferedReader createReader(File inFile, String inEncoding) throws UnsupportedEncodingException, IOException {
        XMLReader xmlreader = new XMLReader(inFile, inEncoding);
        this.encoding = xmlreader.getEncoding();
        this.eol = xmlreader.getEol();
        return new BufferedReader(xmlreader);
    }

    @Override
    public BufferedWriter createWriter(File outFile, String outEncoding) throws UnsupportedEncodingException, IOException {
        if (outFile == null) {
            return new BufferedWriter(new StringWriter());
        }
        if (outEncoding == null) {
            outEncoding = this.encoding;
        }
        return new BufferedWriter(new XMLWriter(outFile, outEncoding, this.eol));
    }

    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        block13: {
            try (BufferedReader inReader = this.createReader(inFile, fc.getInEncoding());){
                this.inEncodingLastParsedFile = this.encoding;
                if (outFile != null) {
                    try (BufferedWriter writer = this.createWriter(outFile, fc.getOutEncoding());){
                        this.processFile(inReader, writer, fc);
                        break block13;
                    }
                }
                this.processFile(inReader, null, fc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(BufferedReader inReader, BufferedWriter writer, FilterContext fc) throws IOException, TranslationException {
        try {
            XMLStreamReader strReader = null;
            XMLStreamWriter strWriter = null;
            XMLEventReader eventReader = null;
            try {
                strReader = this.iFactory.createXMLStreamReader(inReader);
                eventReader = this.iFactory.createXMLEventReader(strReader);
                this.isEventMode = false;
                if (writer == null) {
                    while (strReader.hasNext()) {
                        if (!this.isEventMode) {
                            this.checkCurrentCursorPosition(strReader, false);
                        }
                        if (this.isEventMode) {
                            XMLEvent event = eventReader.nextEvent();
                            if (event.isStartElement()) {
                                this.processStartElement(event.asStartElement(), null);
                                continue;
                            }
                            if (event.isEndElement()) {
                                this.processEndElement(event.asEndElement(), null);
                                continue;
                            }
                            if (!event.isCharacters()) continue;
                            this.processCharacters(event.asCharacters(), null);
                            continue;
                        }
                        strReader.next();
                    }
                } else {
                    strWriter = this.oFactory.createXMLStreamWriter(writer);
                    strWriter.setNamespaceContext(strReader.getNamespaceContext());
                    while (strReader.hasNext()) {
                        if (strReader.getEventType() == 7) {
                            String escheme;
                            StringBuilder sb = new StringBuilder("<?xml ");
                            String version = strReader.getVersion();
                            if (version != null) {
                                sb.append(" version=\"").append(version).append("\"");
                            }
                            if ((escheme = strReader.getCharacterEncodingScheme()) != null) {
                                sb.append(" encoding=\"").append(escheme).append("\"");
                            }
                            if (strReader.standaloneSet()) {
                                sb.append(" standalone=\"").append(strReader.isStandalone() ? "yes" : "no").append("\"");
                            }
                            sb.append(" ?>");
                            writer.write(sb.toString());
                            strReader.next();
                            continue;
                        }
                        if (!this.isEventMode) {
                            this.checkCurrentCursorPosition(strReader, true);
                            this.fromReaderToWriter(strReader, strWriter);
                        }
                        if (this.isEventMode) {
                            XMLEvent event = eventReader.nextEvent();
                            boolean keep = event.isStartElement() ? this.processStartElement(event.asStartElement(), strWriter) : (event.isEndElement() ? this.processEndElement(event.asEndElement(), strWriter) : (event.isCharacters() ? this.processCharacters(event.asCharacters(), strWriter) : true));
                            if (!keep) continue;
                            this.fromEventToWriter(event, strWriter);
                            continue;
                        }
                        strReader.next();
                    }
                }
            }
            finally {
                if (eventReader != null) {
                    eventReader.close();
                }
                if (strReader != null) {
                    strReader.close();
                }
                if (strWriter != null) {
                    strWriter.flush();
                    strWriter.close();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new TranslationException(e);
        }
    }

    protected abstract void checkCurrentCursorPosition(XMLStreamReader var1, boolean var2);

    protected abstract boolean processStartElement(StartElement var1, XMLStreamWriter var2) throws IOException, XMLStreamException;

    protected abstract boolean processEndElement(EndElement var1, XMLStreamWriter var2) throws IOException, XMLStreamException;

    protected abstract boolean processCharacters(Characters var1, XMLStreamWriter var2) throws IOException, XMLStreamException;

    private void fromReaderToWriter(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        switch (xmlr.getEventType()) {
            case 9: {
                writer.writeEntityRef(xmlr.getLocalName());
                break;
            }
            case 11: {
                writer.writeDTD(xmlr.getText());
                break;
            }
            case 1: {
                int i;
                String localName = xmlr.getLocalName();
                String namespaceURI = xmlr.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.length() > 0) {
                    String prefix = xmlr.getPrefix();
                    if (prefix != null && prefix.length() > 0) {
                        writer.writeStartElement(prefix, localName, namespaceURI);
                    } else {
                        writer.writeStartElement(namespaceURI, localName);
                    }
                } else {
                    writer.writeStartElement(localName);
                }
                int len = xmlr.getNamespaceCount();
                for (i = 0; i < len; ++i) {
                    writer.writeNamespace(xmlr.getNamespacePrefix(i), xmlr.getNamespaceURI(i));
                }
                len = xmlr.getAttributeCount();
                for (i = 0; i < len; ++i) {
                    String attUri = xmlr.getAttributeNamespace(i);
                    if (attUri != null && attUri.length() > 0) {
                        writer.writeAttribute(attUri, xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                        continue;
                    }
                    writer.writeAttribute(xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                }
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength());
                break;
            }
            case 3: {
                writer.writeProcessingInstruction(xmlr.getPITarget(), xmlr.getPIData());
                break;
            }
            case 12: {
                writer.writeCData(xmlr.getText());
                break;
            }
            case 5: {
                writer.writeComment(xmlr.getText());
                break;
            }
            case 8: {
                writer.writeEndDocument();
            }
        }
    }

    protected final void fromEventToWriter(XMLEvent ev, XMLStreamWriter writer) throws XMLStreamException {
        switch (ev.getEventType()) {
            case 9: {
                writer.writeEntityRef(((EntityReference)ev).getName());
                break;
            }
            case 1: {
                StartElement el = ev.asStartElement();
                QName name = el.getName();
                writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                Iterator<Attribute> iter = el.getNamespaces();
                while (iter.hasNext()) {
                    Namespace ns = iter.next();
                    writer.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                }
                iter = el.getAttributes();
                while (iter.hasNext()) {
                    Attribute attr = iter.next();
                    writer.writeAttribute(attr.getName().getPrefix(), attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                }
                break;
            }
            case 10: {
                writer.writeAttribute(((Attribute)ev).getName().getPrefix(), ((Attribute)ev).getName().getNamespaceURI(), ((Attribute)ev).getName().getLocalPart(), ((Attribute)ev).getValue());
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(((Characters)ev).getData());
                break;
            }
            case 3: {
                writer.writeProcessingInstruction(((ProcessingInstruction)ev).getTarget(), ((ProcessingInstruction)ev).getData());
                break;
            }
            case 12: {
                writer.writeCData(((Characters)ev).getData());
                break;
            }
            case 5: {
                writer.writeComment(((Comment)ev).getText());
                break;
            }
            case 8: {
                writer.writeEndDocument();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StartElement findEvent(File inputFile, Pattern path) throws IOException, TranslationException {
        try (XMLEventReader eventReader = null;){
            eventReader = this.iFactory.createXMLEventReader(new FileInputStream(inputFile));
            Object curPath = "/";
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement el = event.asStartElement();
                    if (!path.matcher((CharSequence)(curPath = (String)curPath + "/" + el.getName().getNamespaceURI() + ":" + el.getName().getLocalPart())).matches()) continue;
                    StartElement startElement = el;
                    return startElement;
                }
                if (!event.isEndElement()) continue;
                curPath = ((String)curPath).substring(0, ((String)curPath).lastIndexOf("/"));
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new TranslationException(e);
        }
    }

    protected List<XMLEvent> restoreTags(String tra) {
        LinkedList<XMLEvent> res = new LinkedList<XMLEvent>();
        while (tra.length() > 0) {
            Matcher m = OMEGAT_TAG.matcher(tra);
            if (m.find()) {
                res.add(eFactory.createCharacters(tra.substring(0, m.start())));
                List<XMLEvent> saved = this.tagsMap.get(m.group(1) + m.group(2));
                if (saved != null) {
                    res.addAll(saved);
                }
                tra = tra.substring(m.end());
                continue;
            }
            res.add(eFactory.createCharacters(tra));
            return res;
        }
        return res;
    }

    protected String buildProtectedPartDetails(List<XMLEvent> saved) {
        StringWriter writer = new StringWriter();
        try {
            XMLEventWriter eventWriter = this.oFactory.createXMLEventWriter(writer);
            for (XMLEvent ev : saved) {
                eventWriter.add(ev);
            }
        }
        catch (Exception e) {
            for (XMLEvent ev : saved) {
                if (ev.isEndElement()) {
                    writer.write("</" + ev.asEndElement().getName().getPrefix() + ":" + ev.asEndElement().getName().getLocalPart() + ">");
                    continue;
                }
                writer.write(ev.toString());
            }
        }
        return writer.toString();
    }

    protected List<ProtectedPart> buildProtectedParts(String src) {
        Matcher m;
        LinkedList<ProtectedPart> protectedParts = new LinkedList<ProtectedPart>();
        while (src.length() > 0 && (m = OMEGAT_TAG.matcher(src)).find()) {
            List<XMLEvent> saved = this.tagsMap.get(m.group(1) + m.group(2));
            if (saved != null) {
                ProtectedPart pp = new ProtectedPart();
                pp.setTextInSourceSegment(m.group());
                pp.setDetailsFromSourceFile(this.buildProtectedPartDetails(saved));
                if (StatisticsSettings.isCountingStandardTags()) {
                    pp.setReplacementWordsCountCalculation("\b" + m.group().replace('<', '_').replace('>', '_') + "\b");
                } else {
                    pp.setReplacementWordsCountCalculation("\b");
                }
                pp.setReplacementUniquenessCalculation("\b");
                pp.setReplacementMatchCalculation("\b");
                protectedParts.add(pp);
            }
            src = src.substring(m.end());
        }
        return protectedParts;
    }

    protected static List<XMLEvent> toPair(StartElement ev) {
        LinkedList<XMLEvent> l = new LinkedList<XMLEvent>();
        l.add(ev);
        l.add(eFactory.createEndElement(ev.getName(), null));
        return l;
    }

    protected String findKey(StartElement findEl, boolean isEmpty) {
        for (Map.Entry<String, List<XMLEvent>> me : this.tagsMap.entrySet()) {
            try {
                StartElement mapEl = me.getValue().get(0).asStartElement();
                if (!mapEl.getName().equals(findEl.getName())) continue;
                boolean foundDiff = false;
                Iterator<Attribute> iter = mapEl.getAttributes();
                while (iter.hasNext()) {
                    Attribute curAttr = iter.next();
                    Attribute findAttr = findEl.getAttributeByName(curAttr.getName());
                    if (findAttr == null) {
                        foundDiff = true;
                        continue;
                    }
                    if (findAttr.getValue().equals(curAttr.getValue())) continue;
                    foundDiff = true;
                }
                if (foundDiff) continue;
                return "<" + me.getKey() + (isEmpty ? "/>" : ">");
            }
            catch (Exception exception) {
            }
        }
        return "";
    }
}

