/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import java.util.List;
import java.util.stream.Collectors;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.issues.IssueProviders;
import org.omegat.languagetools.BaseLanguageToolBridge;
import org.omegat.languagetools.ILanguageToolBridge;
import org.omegat.languagetools.LanguageToolIssueProvider;
import org.omegat.languagetools.LanguageToolNativeBridge;
import org.omegat.languagetools.LanguageToolNetworkBridge;
import org.omegat.languagetools.LanguageToolPrefs;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.Styles;

public final class LanguageToolWrapper {
    private static volatile ILanguageToolBridge bridge;

    private LanguageToolWrapper() {
    }

    public static void init() {
        Core.registerMarker(new LanguageToolMarker());
        IssueProviders.addIssueProvider(new LanguageToolIssueProvider());
        CoreEvents.registerProjectChangeListener(e -> {
            switch (e) {
                case CREATE: 
                case LOAD: {
                    LanguageToolWrapper.setBridgeFromCurrentProject();
                    break;
                }
                case CLOSE: {
                    if (bridge != null) {
                        bridge.stop();
                    }
                    bridge = null;
                    break;
                }
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationShutdown() {
                if (bridge != null) {
                    bridge.stop();
                }
            }

            @Override
            public void onApplicationStartup() {
            }
        });
    }

    static ILanguageToolBridge getBridge() {
        return bridge;
    }

    public static void setBridgeFromCurrentProject() {
        if (bridge != null) {
            bridge.stop();
        }
        if (Core.getProject().isProjectLoaded()) {
            Language sourceLang = Core.getProject().getProjectProperties().getSourceLanguage();
            Language targetLang = Core.getProject().getProjectProperties().getTargetLanguage();
            bridge = LanguageToolWrapper.createBridgeFromPrefs(sourceLang, targetLang);
        }
    }

    static ILanguageToolBridge createBridgeFromPrefs(Language sourceLang, Language targetLang) {
        BaseLanguageToolBridge bridge;
        BridgeType type = LanguageToolPrefs.getBridgeType();
        try {
            switch (type) {
                case LOCAL_INSTALLATION: {
                    String localServerJarPath = LanguageToolPrefs.getLocalServerJarPath();
                    bridge = new LanguageToolNetworkBridge(sourceLang, targetLang, localServerJarPath, 8081);
                    break;
                }
                case REMOTE_URL: {
                    String remoteUrl = LanguageToolPrefs.getRemoteUrl();
                    bridge = new LanguageToolNetworkBridge(sourceLang, targetLang, remoteUrl);
                    break;
                }
                default: {
                    bridge = new LanguageToolNativeBridge(sourceLang, targetLang);
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.logWarningRB("LT_BAD_CONFIGURATION", new Object[0]);
            bridge = new LanguageToolNativeBridge(sourceLang, targetLang);
        }
        LanguageToolPrefs.applyRules(bridge, targetLang.getLanguageCode());
        return bridge;
    }

    static class LanguageToolMarker
    implements IMarker {
        static final Highlighter.HighlightPainter PAINTER = new UnderlineFactory.WaveUnderline(Styles.EditorColor.COLOR_LANGUAGE_TOOLS.getColor());

        LanguageToolMarker() {
        }

        @Override
        public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
            if (translationText == null || !this.isEnabled()) {
                return null;
            }
            translationText = StringUtil.normalizeUnicode(translationText);
            if (sourceText == null) {
                sourceText = ste.getSrcText();
            }
            return bridge.getCheckResults(sourceText, translationText).stream().map(match -> {
                Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, match.start, match.end);
                m.toolTipText = match.message;
                m.painter = PAINTER;
                return m;
            }).collect(Collectors.toList());
        }

        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkLanguageChecker();
        }
    }

    public static enum BridgeType {
        NATIVE,
        REMOTE_URL,
        LOCAL_INSTALLATION;

    }
}

