/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;

class AccentuationDataLoader {
    private static final String FILE_ENCODING = "utf-8";

    AccentuationDataLoader() {
    }

    Map<String, AnalyzedTokenReadings> loadWords(String path) {
        HashMap<String, AnalyzedTokenReadings> map = new HashMap<String, AnalyzedTokenReadings>();
        InputStream inputStream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        try (Scanner scanner = new Scanner(inputStream, FILE_ENCODING);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 3) {
                    throw new RuntimeException("Format error in file " + path + ", line: " + line + ", " + "expected 3 semicolon-separated parts, got " + parts.length);
                }
                AnalyzedToken analyzedToken = new AnalyzedToken(parts[1], parts[2], null);
                map.put(parts[0], new AnalyzedTokenReadings(analyzedToken, 0));
            }
        }
        return map;
    }
}

