/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autocompleter;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.omegat.gui.editor.autocompleter.AbstractAutoCompleterView;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterKeys;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Token;

public abstract class AutoCompleterListView
extends AbstractAutoCompleterView {
    private static JList<AutoCompleterItem> list;
    private static final AutoCompleterItem NO_SUGGESTIONS;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int i = list.locationToIndex(p);
                if (list.getSelectedIndex() == i && list.getCellBounds(i, i).contains(p)) {
                    AutoCompleterListView.this.completer.doSelection();
                }
            }
        }
    };
    private static final Border LIST_MARGIN_BORDER;

    public AutoCompleterListView(String name) {
        super(name);
        this.getList().setFocusable(false);
    }

    public JList<AutoCompleterItem> getList() {
        if (list == null) {
            list = new JList();
            list.setCellRenderer(new CellRenderer());
            list.addMouseListener(this.mouseAdapter);
        }
        return list;
    }

    @Override
    public boolean processKeys(KeyEvent e) {
        int code = e.getKeyCode();
        if ((code == 37 || code == 39) && this.completer.isVisible() && this.completer.didPopUpAutomatically) {
            this.completer.setVisible(false);
            return false;
        }
        KeyStroke s = KeyStroke.getKeyStrokeForEvent(e);
        AutoCompleterKeys keys = this.completer.getKeys();
        if (s.equals(keys.listUp) || s.equals(keys.listUpEmacs)) {
            this.selectPreviousPossibleValue();
            return true;
        }
        if (s.equals(keys.listDown) || s.equals(keys.listDownEmacs)) {
            this.selectNextPossibleValue();
            return true;
        }
        if (s.equals(keys.listPageUp)) {
            this.selectPreviousPossibleValueByPage();
            return true;
        }
        if (s.equals(keys.listPageDown)) {
            this.selectNextPossibleValueByPage();
            return true;
        }
        return false;
    }

    protected void selectNextPossibleValue() {
        int i = (this.getList().getSelectedIndex() + 1) % this.getList().getModel().getSize();
        this.getList().setSelectedIndex(i);
        this.getList().ensureIndexIsVisible(i);
    }

    protected void selectNextPossibleValueByPage() {
        int page = this.getList().getLastVisibleIndex() - this.getList().getFirstVisibleIndex();
        int i = Math.min(this.getList().getSelectedIndex() + page, this.getList().getModel().getSize() - 1);
        this.getList().setSelectedIndex(i);
        this.getList().ensureIndexIsVisible(i);
    }

    protected void selectPreviousPossibleValue() {
        int size = this.getList().getModel().getSize();
        int i = (this.getList().getSelectedIndex() - 1 + size) % size;
        this.getList().setSelectedIndex(i);
        this.getList().ensureIndexIsVisible(i);
    }

    protected void selectPreviousPossibleValueByPage() {
        int page = this.getList().getLastVisibleIndex() - this.getList().getFirstVisibleIndex();
        int i = Math.max(this.getList().getSelectedIndex() - page, 0);
        this.getList().setSelectedIndex(i);
        this.getList().ensureIndexIsVisible(i);
    }

    @Override
    public int getRowCount() {
        return this.getList().getModel().getSize();
    }

    @Override
    public int getPreferredHeight() {
        Rectangle bounds = this.getList().getCellBounds(0, 0);
        return (int)((double)this.getModifiedRowCount() * (bounds == null ? (double)this.getList().getFont().getSize() : bounds.getHeight()));
    }

    @Override
    public int getPreferredWidth() {
        int width = this.getList().getPreferredSize().width;
        JScrollBar bar = this.completer.scroll.getVerticalScrollBar();
        if (bar != null) {
            width += bar.getPreferredSize().width;
        }
        return width;
    }

    protected void setData(AutoCompleterItem ... entries) {
        this.getList().setListData((AutoCompleterItem[])entries);
        if (entries.length > 0) {
            this.getList().setSelectedIndex(0);
            this.getList().invalidate();
            this.getList().scrollRectToVisible(new Rectangle());
        }
    }

    @Override
    public AutoCompleterItem getSelectedValue() {
        AutoCompleterItem item = this.getList().getSelectedValue();
        return item == NO_SUGGESTIONS ? null : item;
    }

    @Override
    public Component getViewContent() {
        this.getList().setVisibleRowCount(this.getModifiedRowCount());
        return this.getList();
    }

    @Override
    public void updateViewData() {
        List<AutoCompleterItem> entryList = this.computeListData(this.getLeadingText(), false);
        if (entryList.isEmpty()) {
            this.setData(NO_SUGGESTIONS);
        } else {
            this.setData(entryList.toArray(new AutoCompleterItem[entryList.size()]));
        }
    }

    @Override
    public boolean shouldPopUp() {
        return !this.computeListData(this.getLeadingText(), true).isEmpty();
    }

    protected String getLastToken(String text) {
        Token lastToken;
        String lastString;
        String token = "";
        ITokenizer tokenizer = this.getTokenizer();
        Token[] tokens = tokenizer.tokenizeVerbatim(text);
        if (tokens.length != 0 && !(lastString = text.substring((lastToken = tokens[tokens.length - 1]).getOffset()).trim()).isEmpty()) {
            token = lastString;
        }
        return token;
    }

    public abstract List<AutoCompleterItem> computeListData(String var1, boolean var2);

    public abstract String itemToString(AutoCompleterItem var1);

    static {
        NO_SUGGESTIONS = new AutoCompleterItem(OStrings.getString("AC_NO_SUGGESTIONS"), null, 0);
        LIST_MARGIN_BORDER = new EmptyBorder(0, 5, 0, 5);
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBorder(LIST_MARGIN_BORDER);
            if (value == NO_SUGGESTIONS) {
                this.setText(((AutoCompleterItem)value).payload);
            } else {
                AutoCompleterListView aclView = (AutoCompleterListView)AutoCompleterListView.this.completer.getCurrentView();
                AutoCompleterItem acItem = (AutoCompleterItem)value;
                this.setText(aclView.itemToString(acItem));
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

