/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.jgit.api.Git;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.StringUtil;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public final class TeamTool {
    public static final String COMMAND_INIT = "init";

    private TeamTool() {
    }

    public static void initTeamProject(File dir, String srcLang, String trgLang) throws Exception {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Specified dir is not a directory: " + dir.getPath());
        }
        if (!dir.canWrite()) {
            throw new IOException("Specified dir is not writeable: " + dir.getPath());
        }
        ProjectProperties props = new ProjectProperties(dir);
        props.setSourceLanguage(srcLang);
        props.setTargetLanguage(trgLang);
        props.setSourceTokenizer(PluginUtils.getTokenizerClassForLanguage(new Language(srcLang)));
        props.setTargetTokenizer(PluginUtils.getTokenizerClassForLanguage(new Language(trgLang)));
        props.autocreateDirectories();
        GlossaryManager.createNewWritableGlossaryFile(props.getWritableGlossaryFile().getAsFile());
        ProjectFileStorage.writeProjectFile(props);
        new ProjectTMX(props.getSourceLanguage(), props.getTargetLanguage(), props.isSentenceSegmentingEnabled(), null, null).save(props, new File(props.getProjectInternal(), "project_save.tmx").getPath(), false);
        if (new File(dir, ".svn").isDirectory()) {
            SVNClientManager mgr = SVNClientManager.newInstance();
            mgr.getWCClient().doSetProperty(dir, "svn:auto-props", SVNPropertyValue.create((String)"*.txt = svn:eol-style=native\n*.tmx = svn:eol-style=native\n"), false, SVNDepth.EMPTY, null, null);
            mgr.getWCClient().doAdd(dir.listFiles(f -> !f.getName().startsWith(".")), false, false, true, SVNDepth.fromRecurse((boolean)true), false, false, false, true);
        } else if (new File(dir, ".git").isDirectory()) {
            try (BufferedWriter writer = Files.newBufferedWriter(new File(dir, ".gitattributes").toPath(), new OpenOption[0]);){
                writer.write("* text=auto\n");
                writer.write("*.tmx text\n");
                writer.write("*.txt text\n");
            }
            Git.open((File)dir).add().addFilepattern(".").call();
        }
        System.out.println(StringUtil.format(OStrings.getString("TEAM_TOOL_INIT_COMPLETE"), srcLang, trgLang));
    }

    public static void showHelp() {
        System.out.println(StringUtil.format(OStrings.getString("TEAM_TOOL_HELP"), OStrings.getNameAndVersion()));
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            TeamTool.showHelp();
            System.exit(1);
        }
        if (Arrays.asList("--help", "-h").contains(args[0])) {
            TeamTool.showHelp();
            System.exit(0);
        }
        Log.setLevel(Level.WARNING);
        try {
            Preferences.init();
            PluginUtils.loadPlugins(Collections.emptyMap());
            if (COMMAND_INIT.equals(args[0]) && args.length == 3) {
                TeamTool.initTeamProject(new File("").getAbsoluteFile(), args[1], args[2]);
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        TeamTool.showHelp();
        System.exit(1);
    }
}

