/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.omegat.externalfinder.item.ExternalFinderConfiguration;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemCommand;
import org.omegat.externalfinder.item.ExternalFinderItemURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExternalFinderXMLWriter {
    private final File file;

    public ExternalFinderXMLWriter(File file) {
        this.file = Objects.requireNonNull(file);
    }

    public void write(ExternalFinderConfiguration config) throws Exception {
        Document doc = this.createDocument(config);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(this.file);
        transformer.transform(source, result);
    }

    private Document createDocument(ExternalFinderConfiguration config) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("items");
        doc.appendChild(root);
        if (config.getPriority() >= 0) {
            root.setAttribute("priority", Integer.toString(config.getPriority()));
        }
        for (ExternalFinderItem i : config.getItems()) {
            root.appendChild(this.createItem(doc, i));
        }
        return doc;
    }

    private Element createItem(Document doc, ExternalFinderItem i) {
        Element item = doc.createElement("item");
        if (i.isNopopup()) {
            item.setAttribute("nopopup", Boolean.TRUE.toString());
        }
        Iterator<ExternalFinderItemCommand> name = doc.createElement("name");
        name.setTextContent(i.getName());
        item.appendChild((Node)((Object)name));
        for (ExternalFinderItemURL u : i.getURLs()) {
            item.appendChild(this.createUrl(doc, u));
        }
        for (ExternalFinderItemCommand c : i.getCommands()) {
            item.appendChild(this.createCommand(doc, c));
        }
        if (i.getKeystroke() != null) {
            Element keystroke = doc.createElement("keystroke");
            keystroke.setTextContent(i.getKeystroke().toString());
            item.appendChild(keystroke);
        }
        return item;
    }

    private Element createUrl(Document doc, ExternalFinderItemURL u) {
        Element url = doc.createElement("url");
        if (u.getTarget() != null) {
            url.setAttribute("target", u.getTarget().name().toLowerCase(Locale.ENGLISH));
        }
        if (u.getEncoding() != null) {
            url.setAttribute("encoding", u.getEncoding().name().toLowerCase(Locale.ENGLISH));
        }
        url.setTextContent(u.getURL());
        return url;
    }

    private Element createCommand(Document doc, ExternalFinderItemCommand c) {
        Element command = doc.createElement("command");
        if (c.getTarget() != null) {
            command.setAttribute("target", c.getTarget().name().toLowerCase(Locale.ENGLISH));
        }
        if (c.getEncoding() != null) {
            command.setAttribute("encoding", c.getEncoding().name().toLowerCase(Locale.ENGLISH));
        }
        command.setAttribute("delimiter", c.getDelimiter());
        command.setTextContent(c.getCommand());
        return command;
    }
}

