/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail;

import java.util.NoSuchElementException;

public class TailCharIterator {
    private CharSequence chars;
    private int index;
    private char current = '\u0000';
    private char next = '\u0000';

    public TailCharIterator(CharSequence chars, int index) {
        this.chars = chars;
        this.index = index;
        if (this.index != -1) {
            this.next = chars.charAt(index);
        }
    }

    public void setOffset(int offset) {
        this.setIndex(offset);
    }

    public void setIndex(int index) {
        this.index = index;
        this.current = '\u0000';
        this.next = this.index != -1 ? this.chars.charAt(index) : (char)'\u0000';
    }

    public int getNextIndex() {
        return this.index;
    }

    public boolean hasNext() {
        return this.index != -1;
    }

    public char next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        ++this.index;
        char c = this.chars.charAt(this.index);
        if (c == '\u0000') {
            this.index = -1;
        } else if (c == '\u0001') {
            int i = this.chars.charAt(this.index + 1);
            this.index = i += this.chars.charAt(this.index + 2) << 16;
            c = this.chars.charAt(this.index);
        }
        this.next = c;
        return this.current;
    }

    public char current() {
        return this.current;
    }
}

