/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Ukrainian;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;

public class UkrainianHybridDisambiguator
implements Disambiguator {
    private static final String LAST_NAME_TAG = ":lname";
    private static final Pattern INITIAL_REGEX = Pattern.compile("[\u0410-\u042f\u0406\u0407\u0404\u0490]");
    private final Disambiguator chunker = new MultiWordChunker("/uk/multiwords.txt", true);
    private final Disambiguator disambiguator = new XmlRuleDisambiguator((Language)new Ukrainian());

    public final AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        this.retagInitials(input);
        return this.disambiguator.disambiguate(this.chunker.disambiguate(input));
    }

    private void retagInitials(AnalyzedSentence input) {
        AnalyzedTokenReadings[] tokens = input.getTokens();
        for (int i = 0; i < tokens.length - 2; ++i) {
            AnalyzedTokenReadings newReadings;
            if (!UkrainianHybridDisambiguator.isInitial(tokens, i)) continue;
            boolean spaced = UkrainianHybridDisambiguator.isSpace(tokens[i + 2].getToken());
            int spacedOffset = spaced ? 1 : 0;
            int nextPos = i + 2 + spacedOffset;
            if (nextPos + 2 + spacedOffset < tokens.length && UkrainianHybridDisambiguator.isInitial(tokens, nextPos) && (!spaced || UkrainianHybridDisambiguator.isSpace(tokens[nextPos + 2].getToken())) && tokens[nextPos + 2 + spacedOffset].hasPartialPosTag(LAST_NAME_TAG)) {
                AnalyzedTokenReadings newReadings2;
                int currPos = nextPos;
                tokens[currPos] = newReadings2 = UkrainianHybridDisambiguator.getInitialReadings(tokens[currPos], tokens[nextPos += 2 + spacedOffset], "patr");
            }
            if (nextPos >= tokens.length || !tokens[nextPos].hasPartialPosTag(LAST_NAME_TAG)) continue;
            tokens[i] = newReadings = UkrainianHybridDisambiguator.getInitialReadings(tokens[i], tokens[nextPos], "fname");
            i = nextPos;
        }
    }

    private static AnalyzedTokenReadings getInitialReadings(AnalyzedTokenReadings initialsReadings, AnalyzedTokenReadings lnameTokens, String initialType) {
        ArrayList<AnalyzedToken> newTokens = new ArrayList<AnalyzedToken>();
        for (AnalyzedToken lnameToken : lnameTokens.getReadings()) {
            String lnamePosTag = lnameToken.getPOSTag();
            if (lnamePosTag == null || !lnamePosTag.contains(LAST_NAME_TAG)) continue;
            String initialsToken = initialsReadings.getAnalyzedToken(0).getToken();
            AnalyzedToken newToken = new AnalyzedToken(initialsToken, lnamePosTag.replace(LAST_NAME_TAG, ":" + initialType + ":abbr"), initialsToken);
            newTokens.add(newToken);
        }
        return new AnalyzedTokenReadings(newTokens, initialsReadings.getStartPos());
    }

    private static boolean isInitial(AnalyzedTokenReadings[] tokens, int pos) {
        return pos < tokens.length - 2 && tokens[pos + 1].getToken().equals(".") && INITIAL_REGEX.matcher(tokens[pos].getToken()).matches();
    }

    private static boolean isSpace(String str) {
        return str != null && (str.equals(" ") || str.equals("\u00a0"));
    }
}

