/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public final class WikiGet {
    protected static final String CHARSET_MARK = "charset=";
    protected static final String DEFAULT_RESPONSE_CHARSET = "ISO-8859-1";

    private WikiGet() {
    }

    public static String joinString(String separator, String[] items) {
        if (items.length < 1) {
            return "";
        }
        StringBuilder joined = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            joined.append(items[i]);
            if (i == items.length - 1) continue;
            joined.append(separator);
        }
        return joined.toString();
    }

    public static void doWikiGet(String remoteUrl, String projectdir) throws IOException {
        String[] splitted;
        String joined = null;
        String name = null;
        if (remoteUrl.indexOf("index.php?title=") > 0) {
            String s;
            splitted = remoteUrl.split("index.php\\?title=");
            name = s = splitted[splitted.length - 1];
            splitted[splitted.length - 1] = s = s.replaceAll(" ", "_");
            joined = WikiGet.joinString("index.php?title=", splitted);
            joined = joined + "&action=raw";
        } else {
            String s;
            splitted = remoteUrl.split("/");
            name = s = splitted[splitted.length - 1];
            splitted[splitted.length - 1] = s = s.replaceAll(" ", "_");
            joined = WikiGet.joinString("/", splitted);
            joined = joined + "?action=raw";
        }
        String page = WikiGet.getURL(joined);
        WikiGet.saveUTF8(projectdir, name + ".UTF8", page);
    }

    public static void printUTF8(String output) {
        try (BufferedWriter out = WikiGet.utf8WriterBuilder(System.out);){
            out.write(output);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedWriter utf8WriterBuilder(OutputStream out) throws Exception {
        return new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8.name()));
    }

    public static void saveUTF8(String dir, String filename, String output) {
        filename = filename.replaceAll("[\\\\/:\\*\\?\\\"\\|\\<\\>]", "_");
        File path = new File(dir, filename);
        try (BufferedWriter out = WikiGet.utf8WriterBuilder(new FileOutputStream(path));){
            out.write(output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getURL(String target) throws IOException {
        int n;
        StringBuilder page = new StringBuilder();
        URL url = new URL(target);
        InputStream in = url.openStream();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            page.append(new String(b, 0, n, "UTF-8"));
        }
        return page.toString();
    }

    public static byte[] getURLasByteArray(String target) throws IOException {
        URL url = new URL(target);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn.getResponseCode() != 200) {
            return null;
        }
        try {
            byte[] byArray;
            block10: {
                InputStream in = conn.getInputStream();
                try {
                    byArray = IOUtils.toByteArray(in);
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String post(String address, Map<String, String> params) throws IOException {
        return WikiGet.post(address, params, null);
    }

    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        return WikiGet.get(address, params, additionalHeaders, DEFAULT_RESPONSE_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders, String defaultOutputCharset) throws IOException {
        String url;
        if (params == null || params.isEmpty()) {
            url = address;
        } else {
            StringBuilder s = new StringBuilder();
            s.append(address).append('?');
            boolean next = false;
            for (Map.Entry<String, String> p : params.entrySet()) {
                if (next) {
                    s.append('&');
                } else {
                    next = true;
                }
                s.append(p.getKey());
                s.append('=');
                s.append(URLEncoder.encode(p.getValue(), StandardCharsets.UTF_8.name()));
            }
            url = s.toString();
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            conn.setRequestMethod("GET");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> en : additionalHeaders.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            WikiGet.addProxyAuthentication(conn);
            conn.setDoOutput(true);
            String string = WikiGet.getStringContent(conn, defaultOutputCharset);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String post(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        URL url = new URL(address);
        ByteArrayOutputStream pout = new ByteArrayOutputStream();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (pout.size() > 0) {
                    pout.write(38);
                }
                pout.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
                pout.write(61);
                pout.write(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8));
            }
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(pout.size()));
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        WikiGet.addProxyAuthentication(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        try {
            String string;
            block14: {
                OutputStream outputStream = conn.getOutputStream();
                try {
                    outputStream.write(pout.toByteArray());
                    outputStream.flush();
                    string = WikiGet.getStringContent(conn);
                    if (outputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String postJSON(String address, String json, Map<String, String> additionalHeaders) throws IOException {
        URL url = new URL(address);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Content-Length", Integer.toString(json.length()));
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> en : additionalHeaders.entrySet()) {
                conn.setRequestProperty(en.getKey(), en.getValue());
            }
        }
        WikiGet.addProxyAuthentication(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        try {
            String string;
            block11: {
                OutputStream cout = conn.getOutputStream();
                try {
                    cout.write(json.getBytes(StandardCharsets.UTF_8));
                    cout.flush();
                    string = WikiGet.getStringContent(conn, "utf-8");
                    if (cout == null) break block11;
                }
                catch (Throwable throwable) {
                    if (cout != null) {
                        try {
                            cout.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cout.close();
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private static void addProxyAuthentication(HttpURLConnection conn) {
        String encodedUser = Preferences.getPreference("proxy_user_name");
        if (!StringUtil.isEmpty(encodedUser)) {
            String encodedPassword = Preferences.getPreference("proxy_password");
            try {
                String userPass = StringUtil.decodeBase64(encodedUser, StandardCharsets.ISO_8859_1) + ":" + StringUtil.decodeBase64(encodedPassword, StandardCharsets.ISO_8859_1);
                String encodedUserPass = Base64.getMimeEncoder().encodeToString(userPass.getBytes(StandardCharsets.ISO_8859_1));
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPass);
            }
            catch (IllegalArgumentException ex) {
                Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
                Log.log(ex);
            }
        }
    }

    private static String getStringContent(HttpURLConnection conn) throws IOException {
        return WikiGet.getStringContent(conn, DEFAULT_RESPONSE_CHARSET);
    }

    private static String getStringContent(HttpURLConnection conn, String defaultCharset) throws IOException {
        if (conn.getResponseCode() != 200) {
            throw new ResponseError(conn);
        }
        String contentType = conn.getHeaderField("Content-Type");
        int cp = contentType != null ? contentType.indexOf(CHARSET_MARK) : -1;
        String charset = cp >= 0 ? contentType.substring(cp + CHARSET_MARK.length()) : defaultCharset;
        try (InputStream in = conn.getInputStream();){
            String string = IOUtils.toString(in, charset);
            return string;
        }
    }

    public static class ResponseError
    extends IOException {
        public final int code;
        public final String message;
        public final String body;

        public ResponseError(HttpURLConnection conn) throws IOException {
            super(conn.getResponseCode() + ": " + conn.getResponseMessage());
            this.code = conn.getResponseCode();
            this.message = conn.getResponseMessage();
            try (InputStream in = conn.getErrorStream();){
                this.body = IOUtils.toString(in, StandardCharsets.UTF_8.name());
            }
        }
    }
}

