/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.gui.issues.IIssue;
import org.omegat.gui.issues.IIssueProvider;
import org.omegat.gui.issues.IssueDetailSplitPanel;
import org.omegat.gui.issues.SimpleColorIcon;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;

class SpellingIssueProvider
implements IIssueProvider {
    SpellingIssueProvider() {
    }

    @Override
    public String getName() {
        return OStrings.getString("ISSUES_SPELLING_PROVIDER_NAME");
    }

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public List<IIssue> getIssues(SourceTextEntry sourceEntry, TMXEntry tmxEntry) {
        List<Token> misspelled = Core.getSpellChecker().getMisspelledTokens(tmxEntry.translation);
        return misspelled.isEmpty() ? Collections.emptyList() : Arrays.asList(new SpellingIssue(sourceEntry, tmxEntry, misspelled));
    }

    static class SpellingIssue
    implements IIssue {
        private static final Icon ICON = new SimpleColorIcon(Styles.EditorColor.COLOR_SPELLCHECK.getColor());
        private static final AttributeSet ERROR_STYLE;
        private final SourceTextEntry ste;
        private final TMXEntry tmxEntry;
        private final List<Token> misspelledTokens;

        SpellingIssue(SourceTextEntry ste, TMXEntry tmxEntry, List<Token> misspelledTokens) {
            this.ste = ste;
            this.tmxEntry = tmxEntry;
            this.misspelledTokens = misspelledTokens;
        }

        @Override
        public Icon getIcon() {
            return ICON;
        }

        @Override
        public String getTypeName() {
            return OStrings.getString("ISSUES_SPELLING_TYPE");
        }

        @Override
        public int getSegmentNumber() {
            return this.ste.entryNum();
        }

        @Override
        public String getDescription() {
            return this.misspelledTokens.stream().map(tok -> tok.getTextFromString(this.tmxEntry.translation)).distinct().collect(Collectors.joining(OStrings.getString("ISSUES_SPELLING_WORD_DELIMITER")));
        }

        @Override
        public Component getDetailComponent() {
            IssueDetailSplitPanel panel = new IssueDetailSplitPanel();
            panel.firstTextPane.setText(this.ste.getSrcText());
            panel.lastTextPane.setText(this.tmxEntry.translation);
            StyledDocument doc = panel.lastTextPane.getStyledDocument();
            for (Token tok : this.misspelledTokens) {
                doc.setCharacterAttributes(tok.getOffset(), tok.getLength(), ERROR_STYLE, false);
            }
            panel.setMinimumSize(new Dimension(0, panel.firstTextPane.getFont().getSize() * 6));
            return panel;
        }

        @Override
        public boolean hasMenuComponents() {
            return true;
        }

        @Override
        public List<? extends JMenuItem> getMenuComponents() {
            ArrayList result = new ArrayList();
            ISpellChecker checker = Core.getSpellChecker();
            this.misspelledTokens.stream().map(tok -> tok.getTextFromString(this.tmxEntry.translation)).distinct().forEach(word -> {
                boolean enabled = !checker.isIgnoredWord((String)word) && !checker.isLearnedWord((String)word);
                JMenuItem item = new JMenuItem(StringUtil.format(OStrings.getString("ISSUES_SPELLING_LEARN_ITEM"), word));
                item.addActionListener(e -> checker.learnWord((String)word));
                item.setEnabled(enabled);
                result.add(item);
                item = new JMenuItem(StringUtil.format(OStrings.getString("ISSUES_SPELLING_IGNORE_ITEM"), word));
                item.addActionListener(e -> checker.ignoreWord((String)word));
                item.setEnabled(enabled);
                result.add(item);
            });
            return result;
        }

        static {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, Styles.EditorColor.COLOR_SPELLCHECK.getColor());
            StyleConstants.setBold(attr, true);
            ERROR_STYLE = attr;
        }
    }
}

