/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.omegat.core.Core;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.preferences.IPreferencesController;
import org.omegat.gui.preferences.PreferencePanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class PreferencesDialog {
    private final IPreferencesController view;
    private PreferencePanel panel;
    private boolean userDidConfirm;

    public PreferencesDialog(IPreferencesController view) {
        this.view = view;
    }

    public boolean show(Window parent) {
        JDialog dialog = new JDialog();
        dialog.setTitle(this.view.toString());
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        StaticUIUtils.setEscapeClosable(dialog);
        StaticUIUtils.setWindowIcon(dialog);
        this.panel = new PreferencePanel();
        dialog.getContentPane().add(this.panel);
        this.panel.prefsViewPanel.add(this.view.getGui(), "Center");
        this.view.addFurtherActionListener(new IPreferencesController.FurtherActionListener(){

            @Override
            public void setRestartRequired(boolean restartRequired) {
                PreferencesDialog.this.updateMessage();
            }

            @Override
            public void setReloadRequired(boolean reloadRequired) {
                PreferencesDialog.this.updateMessage();
            }
        });
        this.panel.okButton.addActionListener(e -> {
            this.view.persist();
            this.userDidConfirm = true;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        this.panel.cancelButton.addActionListener(e -> StaticUIUtils.closeWindowByEvent(dialog));
        this.panel.undoButton.addActionListener(e -> this.undoCurrentView());
        this.panel.resetButton.addActionListener(e -> this.resetCurrentView());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (PreferencesDialog.this.view.isReloadRequired()) {
                    ProjectUICommands.promptReload();
                }
            }
        });
        dialog.getRootPane().setDefaultButton(this.panel.okButton);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.userDidConfirm;
    }

    private void undoCurrentView() {
        this.view.undoChanges();
        this.updateMessage();
    }

    private void resetCurrentView() {
        this.view.restoreDefaults();
        this.updateMessage();
    }

    private void updateMessage() {
        String message = null;
        if (this.view.isRestartRequired()) {
            message = OStrings.getString("PREFERENCES_WARNING_NEEDS_RESTART");
        } else if (this.view.isReloadRequired() && Core.getProject().isProjectLoaded()) {
            message = OStrings.getString("PREFERENCES_WARNING_NEEDS_RELOAD");
        }
        this.panel.messageTextArea.setText(message);
    }
}

