/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.SearchExpression;
import org.omegat.core.search.SearchMode;
import org.omegat.core.search.Searcher;
import org.omegat.core.threads.SearchThread;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.filter.ReplaceFilter;
import org.omegat.gui.editor.filter.SearchFilter;
import org.omegat.gui.search.EntryListPane;
import org.omegat.gui.search.HistoryManager;
import org.omegat.gui.search.SearchWindowForm;
import org.omegat.gui.search.SearchWindowMenu;
import org.omegat.util.Java8Compat;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class SearchWindowController {
    private final SearchWindowForm form = new SearchWindowForm();
    private final SearchMode mode;
    private final int initialEntry;
    private final IEditor.CaretPosition initialCaret;
    private SimpleDateFormat dateFormat;
    private SpinnerDateModel dateFromModel;
    private SpinnerDateModel dateToModel;
    private SearchThread thread;
    private static final String SAVED_DATE_FORMAT = "yyyy/MM/dd HH:mm";

    public SearchWindowController(SearchMode mode) {
        this.form.setJMenuBar(new SearchWindowMenu(this));
        this.mode = mode;
        this.initialEntry = Core.getEditor().getCurrentEntryNumber();
        this.initialCaret = this.getCurrentPositionInEntryTranslationInEditor(Core.getEditor());
        if (Platform.isMacOSX()) {
            OSXIntegration.enableFullScreen(this.form);
        }
        this.dateFormat = new SimpleDateFormat(SAVED_DATE_FORMAT);
        this.form.m_searchField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getSearchItems()));
        if (this.form.m_searchField.getModel().getSize() > 0) {
            this.form.m_searchField.setSelectedIndex(-1);
        }
        this.form.m_replaceField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getReplaceItems()));
        if (this.form.m_replaceField.getModel().getSize() > 0) {
            this.form.m_replaceField.setSelectedIndex(-1);
        }
        Calendar calendar = Calendar.getInstance();
        Date initDate = calendar.getTime();
        calendar.add(1, -100);
        Date earliestDate = calendar.getTime();
        Date latestDate = initDate;
        this.dateFromModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
        this.form.m_dateFromSpinner.setModel(this.dateFromModel);
        this.dateToModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
        this.form.m_dateToSpinner.setModel(this.dateToModel);
        SpinnerNumberModel numberModel = new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1);
        this.form.m_numberOfResults.setModel(numberModel);
        this.loadPreferences();
        if (!Core.getProject().isProjectLoaded()) {
            this.form.m_rbDir.setSelected(true);
            this.form.m_rbProject.setEnabled(false);
        } else {
            this.form.m_rbProject.setSelected(true);
        }
        this.updateOptionStatus();
        this.initActions();
        switch (mode) {
            case SEARCH: {
                this.form.setTitle(OStrings.getString("SW_TITLE"));
                this.form.m_replaceLabel.setVisible(false);
                this.form.m_replaceField.setVisible(false);
                this.form.m_replaceAllButton.setVisible(false);
                this.form.m_replaceButton.setVisible(false);
                this.form.m_panelSearch.setVisible(true);
                this.form.m_panelReplace.setVisible(false);
                break;
            }
            case REPLACE: {
                this.form.setTitle(OStrings.getString("SW_TITLE_REPLACE"));
                this.form.m_SearchInPane.setVisible(false);
                this.form.m_allResultsCB.setVisible(false);
                this.form.m_fileNamesCB.setVisible(false);
                this.form.m_filterButton.setVisible(false);
                this.form.m_numberLabel.setVisible(false);
                this.form.m_numberOfResults.setVisible(false);
                this.form.m_panelSearch.setVisible(false);
                this.form.m_panelReplace.setVisible(true);
                this.form.m_excludeOrphans.setVisible(false);
            }
        }
    }

    public SearchMode getMode() {
        return this.mode;
    }

    final void initActions() {
        this.form.m_dismissButton.addActionListener(e -> this.doCancel());
        this.form.m_filterButton.addActionListener(e -> this.doFilter());
        this.form.m_replaceButton.addActionListener(e -> this.doReplace());
        this.form.m_replaceAllButton.addActionListener(e -> this.doReplaceAll());
        this.form.m_searchButton.addActionListener(e -> this.doSearch());
        this.form.m_advancedButton.addActionListener(e -> this.setAdvancedOptionsVisible(!this.form.m_advancedVisiblePane.isVisible()));
        this.form.m_authorCB.addActionListener(e -> this.enableDisableAuthor());
        this.form.m_authorField.addActionListener(e -> this.doSearch());
        this.form.m_dateToCB.addActionListener(e -> this.enableDisableDateTo());
        this.form.m_dateToButton.addActionListener(e -> this.doResetDateTo());
        this.form.m_dateFromButton.addActionListener(e -> this.doResetDateFrom());
        this.form.m_dateFromCB.addActionListener(e -> this.enableDisableDateFrom());
        this.form.m_dirButton.addActionListener(e -> this.doBrowseDirectory());
        StaticUIUtils.setEscapeAction(this.form, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowController.this.doCancel();
            }
        });
        this.configureHistoryComboBox(this.form.m_searchField);
        this.configureHistoryComboBox(this.form.m_replaceField);
        ActionListener searchFieldRequestFocus = e -> this.form.m_searchField.requestFocus();
        this.form.m_searchExactSearchRB.addActionListener(searchFieldRequestFocus);
        this.form.m_searchKeywordSearchRB.addActionListener(searchFieldRequestFocus);
        this.form.m_searchRegexpSearchRB.addActionListener(searchFieldRequestFocus);
        this.form.m_searchCase.addActionListener(searchFieldRequestFocus);
        this.form.m_searchSpaceMatchNbsp.addActionListener(searchFieldRequestFocus);
        this.form.m_searchSource.addActionListener(searchFieldRequestFocus);
        this.form.m_searchTranslation.addActionListener(searchFieldRequestFocus);
        this.form.m_searchTranslatedUntranslated.addActionListener(searchFieldRequestFocus);
        this.form.m_searchTranslated.addActionListener(searchFieldRequestFocus);
        this.form.m_searchUntranslated.addActionListener(searchFieldRequestFocus);
        this.form.m_searchNotesCB.addActionListener(searchFieldRequestFocus);
        this.form.m_searchCommentsCB.addActionListener(searchFieldRequestFocus);
        this.form.m_cbSearchInGlossaries.addActionListener(searchFieldRequestFocus);
        this.form.m_cbSearchInMemory.addActionListener(searchFieldRequestFocus);
        this.form.m_cbSearchInTMs.addActionListener(searchFieldRequestFocus);
        this.form.m_allResultsCB.addActionListener(searchFieldRequestFocus);
        this.form.m_fileNamesCB.addActionListener(searchFieldRequestFocus);
        this.form.m_autoSyncWithEditor.addActionListener(e -> {
            EntryListPane viewer = (EntryListPane)this.form.m_viewer;
            viewer.setAutoSyncWithEditor(this.form.m_autoSyncWithEditor.isSelected());
        });
        this.form.m_rbDir.addActionListener(e -> {
            this.updateOptionStatus();
            if (this.form.m_rbDir.isSelected()) {
                this.form.m_dirField.requestFocus();
            } else {
                this.form.m_searchField.requestFocus();
            }
        });
        this.form.m_rbProject.addActionListener(e -> {
            this.updateOptionStatus();
            this.form.m_searchField.requestFocus();
        });
        this.form.m_numberOfResults.addChangeListener(e -> this.form.m_searchField.requestFocus());
        this.form.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SearchWindowController.this.savePreferences();
                if (SearchWindowController.this.thread != null) {
                    SearchWindowController.this.thread.fin();
                }
                int currentEntry = Core.getEditor().getCurrentEntryNumber();
                if (SearchWindowController.this.initialEntry > 0 && ((SearchWindowController)SearchWindowController.this).form.m_backToInitialSegment.isSelected() && SearchWindowController.this.initialEntry != currentEntry) {
                    boolean isSegDisplayed = SearchWindowController.this.isSegmentDisplayed(SearchWindowController.this.initialEntry);
                    if (isSegDisplayed) {
                        ((EditorController)Core.getEditor()).gotoEntry(SearchWindowController.this.initialEntry, SearchWindowController.this.initialCaret);
                    } else {
                        Core.getEditor().gotoEntry(SearchWindowController.this.initialEntry);
                    }
                }
            }
        });
    }

    private void configureHistoryComboBox(final JComboBox<String> box) {
        JTextField field = (JTextField)box.getEditor().getEditorComponent();
        InputMap map = field.getInputMap();
        final UndoManager undoManager = new UndoManager();
        field.getDocument().addUndoableEditListener(undoManager);
        KeyStroke undoKey = KeyStroke.getKeyStroke(90, Java8Compat.getMenuShortcutKeyMaskEx(), false);
        map.put(undoKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        KeyStroke redoKey = KeyStroke.getKeyStroke(89, Java8Compat.getMenuShortcutKeyMaskEx(), false);
        map.put(redoKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
        map.put(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (box.isPopupVisible()) {
                    box.hidePopup();
                } else {
                    SearchWindowController.this.doCancel();
                }
            }
        });
        field.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((SearchWindowController)SearchWindowController.this).form.m_searchField.getEditor().getItem().toString().isEmpty()) {
                    SearchWindowController.this.doSearch();
                }
            }
        });
    }

    private void loadPreferences() {
        this.form.setSize(800, 700);
        StaticUIUtils.persistGeometry(this.form, "search_window");
        if (Preferences.isPreferenceDefault("search_window_search_files", false)) {
            this.form.m_rbDir.setSelected(true);
        } else {
            this.form.m_rbProject.setSelected(true);
        }
        this.form.m_dirField.setText(Preferences.getPreferenceDefault("search_window_dir", ""));
        this.form.m_recursiveCB.setSelected(Preferences.isPreferenceDefault("search_window_search_recursive", true));
        SearchExpression.SearchExpressionType searchType = Preferences.getPreferenceEnumDefault("search_window_search_type", SearchExpression.SearchExpressionType.EXACT);
        switch (searchType) {
            default: {
                this.form.m_searchExactSearchRB.setSelected(true);
                break;
            }
            case KEYWORD: {
                this.form.m_searchKeywordSearchRB.setSelected(true);
                break;
            }
            case REGEXP: {
                this.form.m_searchRegexpSearchRB.setSelected(true);
            }
        }
        this.form.m_searchCase.setSelected(Preferences.isPreferenceDefault("search_window_case_sensitive", false));
        this.form.m_searchSpaceMatchNbsp.setSelected(Preferences.isPreferenceDefault("search_window_space_match_nbsp", false));
        this.form.m_searchSource.setSelected(Preferences.isPreferenceDefault("search_window_search_source", true));
        this.form.m_searchTranslation.setSelected(Preferences.isPreferenceDefault("search_window_search_translation", true));
        SearchExpression.SearchState searchState = Preferences.getPreferenceEnumDefault("search_window_search_state", SearchExpression.SearchState.TRANSLATED_UNTRANSLATED);
        switch (searchState) {
            default: {
                this.form.m_searchTranslatedUntranslated.setSelected(true);
                break;
            }
            case TRANSLATED: {
                this.form.m_searchTranslated.setSelected(true);
                break;
            }
            case UNTRANSLATED: {
                this.form.m_searchUntranslated.setSelected(true);
            }
        }
        this.form.m_replaceCase.setSelected(Preferences.isPreferenceDefault("search_window_case_sensitive_replace", false));
        this.form.m_replaceSpaceMatchNbsp.setSelected(Preferences.isPreferenceDefault("search_window_space_match_nbsp_replace", false));
        SearchExpression.SearchExpressionType replaceType = Preferences.getPreferenceEnumDefault("search_window_replace_type", SearchExpression.SearchExpressionType.EXACT);
        switch (replaceType) {
            default: {
                this.form.m_replaceExactSearchRB.setSelected(true);
                break;
            }
            case REGEXP: {
                this.form.m_replaceRegexpSearchRB.setSelected(true);
            }
        }
        this.form.m_replaceUntranslated.setSelected(Preferences.isPreferenceDefault("search_window_replace_untranslated", true));
        this.form.m_searchNotesCB.setSelected(Preferences.isPreferenceDefault("search_window_search_notes", true));
        this.form.m_searchCommentsCB.setSelected(Preferences.isPreferenceDefault("search_window_search_comments", true));
        this.form.m_cbSearchInGlossaries.setSelected(Preferences.isPreferenceDefault("search_window_glossary_search", true));
        this.form.m_cbSearchInMemory.setSelected(Preferences.isPreferenceDefault("search_window_memory_search", true));
        this.form.m_cbSearchInTMs.setSelected(Preferences.isPreferenceDefault("search_window_tm_search", true));
        this.form.m_allResultsCB.setSelected(Preferences.isPreferenceDefault("search_window_all_results", false));
        this.form.m_fileNamesCB.setSelected(Preferences.isPreferenceDefault("search_window_file_names", false));
        this.form.m_autoSyncWithEditor.setSelected(Preferences.isPreferenceDefault("search_window_auto_sync", false));
        this.form.m_backToInitialSegment.setSelected(Preferences.isPreferenceDefault("search_window_back_to_initial_segment", false));
        this.updateOptionStatus();
        this.loadAdvancedOptionPreferences();
        this.updateAdvancedOptionStatus();
    }

    private void savePreferences() {
        if (this.form.m_searchExactSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", (Object)SearchExpression.SearchExpressionType.EXACT);
        } else if (this.form.m_searchKeywordSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", (Object)SearchExpression.SearchExpressionType.KEYWORD);
        } else if (this.form.m_searchRegexpSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", (Object)SearchExpression.SearchExpressionType.REGEXP);
        }
        Preferences.setPreference("search_window_case_sensitive", this.form.m_searchCase.isSelected());
        Preferences.setPreference("search_window_space_match_nbsp", this.form.m_searchSpaceMatchNbsp.isSelected());
        Preferences.setPreference("search_window_search_source", this.form.m_searchSource.isSelected());
        Preferences.setPreference("search_window_search_translation", this.form.m_searchTranslation.isSelected());
        if (this.form.m_searchTranslatedUntranslated.isSelected()) {
            Preferences.setPreference("search_window_search_state", (Object)SearchExpression.SearchState.TRANSLATED_UNTRANSLATED);
        } else if (this.form.m_searchTranslated.isSelected()) {
            Preferences.setPreference("search_window_search_state", (Object)SearchExpression.SearchState.TRANSLATED);
        } else if (this.form.m_searchUntranslated.isSelected()) {
            Preferences.setPreference("search_window_search_state", (Object)SearchExpression.SearchState.UNTRANSLATED);
        }
        Preferences.setPreference("search_window_case_sensitive_replace", this.form.m_replaceCase.isSelected());
        Preferences.setPreference("search_window_space_match_nbsp_replace", this.form.m_replaceSpaceMatchNbsp.isSelected());
        if (this.form.m_replaceExactSearchRB.isSelected()) {
            Preferences.setPreference("search_window_replace_type", (Object)SearchExpression.SearchExpressionType.EXACT);
        } else if (this.form.m_replaceRegexpSearchRB.isSelected()) {
            Preferences.setPreference("search_window_replace_type", (Object)SearchExpression.SearchExpressionType.REGEXP);
        }
        Preferences.setPreference("search_window_replace_untranslated", this.form.m_replaceUntranslated.isSelected());
        Preferences.setPreference("search_window_search_notes", this.form.m_searchNotesCB.isSelected());
        Preferences.setPreference("search_window_search_comments", this.form.m_searchCommentsCB.isSelected());
        Preferences.setPreference("search_window_glossary_search", this.form.m_cbSearchInGlossaries.isSelected());
        Preferences.setPreference("search_window_memory_search", this.form.m_cbSearchInMemory.isSelected());
        Preferences.setPreference("search_window_tm_search", this.form.m_cbSearchInTMs.isSelected());
        Preferences.setPreference("search_window_all_results", this.form.m_allResultsCB.isSelected());
        Preferences.setPreference("search_window_file_names", this.form.m_fileNamesCB.isSelected());
        Preferences.setPreference("search_window_advanced_visible", this.form.m_advancedVisiblePane.isVisible());
        Preferences.setPreference("search_window_search_author", this.form.m_authorCB.isSelected());
        Preferences.setPreference("search_window_author_name", this.form.m_authorField.getText());
        Preferences.setPreference("search_window_date_from", this.form.m_dateFromCB.isSelected());
        Preferences.setPreference("search_window_date_from_value", this.dateFormat.format(this.dateFromModel.getDate()));
        Preferences.setPreference("search_window_date_to", this.form.m_dateToCB.isSelected());
        Preferences.setPreference("search_window_date_to_value", this.dateFormat.format(this.dateToModel.getDate()));
        Preferences.setPreference("search_window_number_of_results", (Integer)this.form.m_numberOfResults.getValue());
        Preferences.setPreference("search_window_exclude_orphans", this.form.m_excludeOrphans.isSelected());
        Preferences.setPreference("search_window_full_half_width_insensitive", this.form.m_fullHalfWidthInsensitive.isSelected());
        Preferences.setPreference("search_window_dir", this.form.m_dirField.getText());
        Preferences.setPreference("search_window_search_files", this.form.m_rbDir.isSelected());
        Preferences.setPreference("search_window_search_recursive", this.form.m_recursiveCB.isSelected());
        Preferences.setPreference("search_window_auto_sync", this.form.m_autoSyncWithEditor.isSelected());
        Preferences.setPreference("search_window_back_to_initial_segment", this.form.m_backToInitialSegment.isSelected());
        HistoryManager.save();
        Preferences.save();
    }

    public void resetOptions() {
        this.form.m_rbProject.setSelected(true);
        this.form.m_recursiveCB.setSelected(true);
        this.form.m_searchExactSearchRB.setSelected(true);
        this.form.m_searchCase.setSelected(false);
        this.form.m_searchSpaceMatchNbsp.setSelected(false);
        this.form.m_searchSource.setSelected(true);
        this.form.m_searchTranslation.setSelected(true);
        this.form.m_searchTranslatedUntranslated.setSelected(true);
        this.form.m_replaceCase.setSelected(false);
        this.form.m_replaceSpaceMatchNbsp.setSelected(false);
        this.form.m_replaceExactSearchRB.setSelected(true);
        this.form.m_replaceUntranslated.setSelected(true);
        this.form.m_searchNotesCB.setSelected(true);
        this.form.m_searchCommentsCB.setSelected(true);
        this.form.m_cbSearchInGlossaries.setSelected(true);
        this.form.m_cbSearchInMemory.setSelected(true);
        this.form.m_cbSearchInTMs.setSelected(true);
        this.form.m_allResultsCB.setSelected(false);
        this.form.m_fileNamesCB.setSelected(false);
        this.updateOptionStatus();
        this.form.m_authorCB.setSelected(false);
        this.form.m_dateFromCB.setSelected(false);
        this.form.m_dateToCB.setSelected(false);
        this.form.m_numberOfResults.setValue(1000);
        this.form.m_excludeOrphans.setSelected(false);
        this.form.m_fullHalfWidthInsensitive.setSelected(false);
        this.updateAdvancedOptionStatus();
    }

    private void updateOptionStatus() {
        this.setEnabled(this.form.m_SearchInProjectPane, this.form.m_rbProject.isSelected());
        this.form.m_rbProject.setEnabled(true);
        this.setEnabled(this.form.m_SearchInDirPane, this.form.m_rbDir.isSelected());
        this.form.m_rbDir.setEnabled(true);
    }

    public void displaySearchResult(final Searcher searcher) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                EntryListPane viewer = (EntryListPane)((SearchWindowController)SearchWindowController.this).form.m_viewer;
                viewer.displaySearchResult(searcher, (Integer)((SearchWindowController)SearchWindowController.this).form.m_numberOfResults.getValue());
                ((SearchWindowController)SearchWindowController.this).form.m_resultsLabel.setText(StringUtil.format(OStrings.getString("SW_NR_OF_RESULTS"), viewer.getNrEntries()));
                boolean haveResults = !searcher.getSearchResults().isEmpty();
                ((SearchWindowController)SearchWindowController.this).form.m_filterButton.setEnabled(haveResults);
                ((SearchWindowController)SearchWindowController.this).form.m_replaceButton.setEnabled(haveResults);
                ((SearchWindowController)SearchWindowController.this).form.m_replaceAllButton.setEnabled(haveResults);
                if (!haveResults) {
                    SearchWindowController.this.focusSearchField();
                } else {
                    viewer.requestFocus();
                }
            }
        });
    }

    private void doBrowseDirectory() {
        File dir;
        OmegaTFileChooser browser = new OmegaTFileChooser();
        browser.setDialogTitle(OStrings.getString("SW_TITLE"));
        browser.setFileSelectionMode(1);
        String curDir = this.form.m_dirField.getText();
        if (!curDir.equals("") && (dir = new File(curDir)).exists() && dir.isDirectory()) {
            browser.setCurrentDirectory(dir);
        }
        browser.showOpenDialog(this.form);
        dir = browser.getSelectedFile();
        if (dir == null) {
            return;
        }
        String str = dir.getAbsolutePath() + File.separator;
        this.form.m_dirField.setText(str);
    }

    private void doFilter() {
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        Core.getEditor().commitAndLeave();
        Core.getEditor().setFilter(new SearchFilter(viewer.getEntryList()));
    }

    private void doReplace() {
        String replaceString = this.form.m_replaceField.getEditor().getItem().toString();
        replaceString = StringUtil.normalizeUnicode(replaceString);
        HistoryManager.addReplaceItem(replaceString);
        this.form.m_replaceField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getReplaceItems()));
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        Core.getEditor().commitAndLeave();
        Core.getEditor().setFilter(new ReplaceFilter(viewer.getEntryList(), viewer.getSearcher()));
    }

    private void doReplaceAll() {
        String replaceString = this.form.m_replaceField.getEditor().getItem().toString();
        replaceString = StringUtil.normalizeUnicode(replaceString);
        HistoryManager.addReplaceItem(replaceString);
        this.form.m_replaceField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getReplaceItems()));
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        Core.getEditor().commitAndDeactivate();
        int count = viewer.getEntryList().size();
        String msg = MessageFormat.format(OStrings.getString("SW_REPLACE_ALL_CONFIRM"), count);
        int r = JOptionPane.showConfirmDialog(this.form, msg, OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
        if (r == 0) {
            new ReplaceFilter(viewer.getEntryList(), viewer.getSearcher()).replaceAll();
        }
        Core.getEditor().activateEntry();
        this.form.m_replaceButton.setEnabled(false);
        this.form.m_replaceAllButton.setEnabled(false);
    }

    private void doSearch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.thread != null) {
            this.thread.fin();
        }
        EntryListPane viewer = (EntryListPane)this.form.m_viewer;
        String queryString = this.form.m_searchField.getEditor().getItem().toString();
        queryString = StringUtil.normalizeUnicode(queryString);
        HistoryManager.addSearchItem(queryString);
        this.form.m_searchField.setModel(new DefaultComboBoxModel<String>(HistoryManager.getSearchItems()));
        this.form.m_searchField.requestFocus();
        viewer.reset();
        String root = null;
        if (this.form.m_rbDir.isSelected()) {
            File f;
            root = this.form.m_dirField.getText();
            if (!root.endsWith(File.separator)) {
                root = root + File.separator;
            }
            if (!(f = new File(root)).exists() || !f.isDirectory()) {
                String error = StringUtil.format(OStrings.getString("SW_ERROR_BAD_DIR"), this.form.m_dirField.getText());
                this.form.m_viewer.setText(error);
                Log.log(error);
                return;
            }
        }
        this.savePreferences();
        if (StringUtil.isEmpty(queryString)) {
            this.form.setTitle(OStrings.getString("SW_TITLE"));
        } else {
            this.form.setTitle(queryString + " - OmegaT");
        }
        SearchExpression s = new SearchExpression();
        s.mode = this.mode;
        s.text = queryString;
        s.rootDir = root;
        s.recursive = this.form.m_recursiveCB.isSelected();
        switch (this.mode) {
            case SEARCH: {
                if (this.form.m_searchExactSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.EXACT;
                } else if (this.form.m_searchKeywordSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.KEYWORD;
                } else if (this.form.m_searchRegexpSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.REGEXP;
                }
                s.caseSensitive = this.form.m_searchCase.isSelected();
                s.spaceMatchNbsp = this.form.m_searchSpaceMatchNbsp.isSelected();
                s.glossary = this.mode == SearchMode.SEARCH ? this.form.m_cbSearchInGlossaries.isSelected() : false;
                s.memory = this.mode == SearchMode.SEARCH ? this.form.m_cbSearchInMemory.isSelected() : true;
                s.tm = this.mode == SearchMode.SEARCH ? this.form.m_cbSearchInTMs.isSelected() : false;
                s.allResults = this.mode == SearchMode.SEARCH ? this.form.m_allResultsCB.isSelected() : true;
                s.fileNames = this.mode == SearchMode.SEARCH ? this.form.m_fileNamesCB.isSelected() : true;
                s.searchSource = this.form.m_searchSource.isSelected();
                s.searchTarget = this.form.m_searchTranslation.isSelected();
                if (this.form.m_searchTranslatedUntranslated.isSelected()) {
                    s.searchTranslated = true;
                    s.searchUntranslated = true;
                } else if (this.form.m_searchTranslated.isSelected()) {
                    s.searchTranslated = true;
                    s.searchUntranslated = false;
                } else if (this.form.m_searchUntranslated.isSelected()) {
                    s.searchTranslated = false;
                    s.searchUntranslated = true;
                }
                s.widthInsensitive = this.form.m_fullHalfWidthInsensitive.isSelected();
                s.excludeOrphans = this.form.m_excludeOrphans.isSelected();
                s.replacement = null;
                break;
            }
            case REPLACE: {
                if (this.form.m_replaceExactSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.EXACT;
                } else if (this.form.m_replaceRegexpSearchRB.isSelected()) {
                    s.searchExpressionType = SearchExpression.SearchExpressionType.REGEXP;
                }
                s.caseSensitive = this.form.m_replaceCase.isSelected();
                s.spaceMatchNbsp = this.form.m_replaceSpaceMatchNbsp.isSelected();
                s.glossary = false;
                s.memory = true;
                s.tm = false;
                s.allResults = true;
                s.fileNames = Core.getProject().getProjectFiles().size() > 1;
                s.searchSource = false;
                s.searchTarget = false;
                s.searchTranslated = false;
                s.searchUntranslated = false;
                s.replaceTranslated = true;
                s.replaceUntranslated = this.form.m_replaceUntranslated.isSelected();
                s.widthInsensitive = this.form.m_fullHalfWidthInsensitive.isSelected();
                s.excludeOrphans = true;
                s.replacement = this.form.m_replaceField.getEditor().getItem().toString();
            }
        }
        s.searchNotes = this.form.m_searchNotesCB.isSelected();
        s.searchComments = this.form.m_searchCommentsCB.isSelected();
        s.searchAuthor = this.form.m_authorCB.isSelected();
        s.author = this.form.m_authorField.getText();
        s.searchDateAfter = this.form.m_dateFromCB.isSelected();
        s.dateAfter = this.dateFromModel.getDate().getTime();
        s.searchDateBefore = this.form.m_dateToCB.isSelected();
        s.dateBefore = this.dateToModel.getDate().getTime();
        s.numberOfResults = this.mode == SearchMode.SEARCH ? (Integer)this.form.m_numberOfResults.getValue() : Integer.MAX_VALUE;
        Searcher searcher = new Searcher(Core.getProject(), s);
        this.thread = new SearchThread(this, searcher);
        this.thread.start();
    }

    void doCancel() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.thread != null) {
            this.thread.fin();
        }
        this.form.dispose();
    }

    public void dispose() {
        this.form.dispose();
    }

    public void makeVisible(String query) {
        if (!StringUtil.isEmpty(query)) {
            this.setSearchText(query);
        }
        this.form.setVisible(true);
        this.form.setState(0);
        this.form.m_searchField.requestFocus();
    }

    private boolean isSegmentDisplayed(int entry) {
        IEditorFilter filter = Core.getEditor().getFilter();
        if (filter == null) {
            return true;
        }
        SourceTextEntry ste = Core.getProject().getAllEntries().get(entry - 1);
        return filter.allowed(ste);
    }

    private void setAdvancedOptionsVisible(boolean visible) {
        this.form.m_advancedVisiblePane.setVisible(visible);
        Mnemonics.setLocalizedText((AbstractButton)this.form.m_advancedButton, (String)(visible ? OStrings.getString("SW_HIDE_ADVANCED_OPTIONS") : OStrings.getString("SW_SHOW_ADVANCED_OPTIONS")));
        this.updateAdvancedOptionStatus();
    }

    private void enableDisableAuthor() {
        boolean editable = this.form.m_authorCB.isSelected();
        this.form.m_authorField.setEditable(editable);
        if (editable) {
            this.form.m_authorField.requestFocus();
        } else {
            this.form.m_searchField.requestFocus();
        }
    }

    private void enableDisableDateFrom() {
        boolean enable = this.form.m_dateFromCB.isSelected();
        this.form.m_dateFromSpinner.setEnabled(enable);
        this.form.m_dateFromButton.setEnabled(enable);
        if (enable) {
            this.form.m_dateFromSpinner.requestFocus();
        } else {
            this.form.m_searchField.requestFocus();
        }
    }

    private void doResetDateFrom() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.dateFromModel.setEnd(now);
        this.dateFromModel.setValue(now);
    }

    private void doResetDateTo() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.dateToModel.setEnd(now);
        this.dateToModel.setValue(now);
    }

    private void enableDisableDateTo() {
        boolean enable = this.form.m_dateToCB.isSelected();
        this.form.m_dateToSpinner.setEnabled(enable);
        this.form.m_dateToButton.setEnabled(enable);
        if (enable) {
            this.form.m_dateToSpinner.requestFocus();
        } else {
            this.form.m_searchField.requestFocus();
        }
    }

    public String getViewerSelection() {
        return this.form.m_viewer.getSelectedText();
    }

    public void setSearchText(String text) {
        JComboBox<String> field = this.form.m_searchField;
        JTextField editor = (JTextField)field.getEditor().getEditorComponent();
        editor.setText(text);
    }

    public void focusSearchField() {
        JComboBox<String> field = this.form.m_searchField;
        field.requestFocus();
        field.getEditor().selectAll();
    }

    private JComboBox<String> getActiveField() {
        return this.form.m_replaceField.hasFocus() ? this.form.m_replaceField : this.form.m_searchField;
    }

    private JTextField getActiveFieldEditor() {
        return (JTextField)this.getActiveField().getEditor().getEditorComponent();
    }

    public void insertIntoActiveField(String text) {
        JTextField editor = this.getActiveFieldEditor();
        int offset = editor.getCaretPosition();
        try {
            editor.getDocument().insertString(offset, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void replaceCurrentFieldText(String text) {
        this.getActiveFieldEditor().setText(text);
    }

    public JFrame getWindow() {
        return this.form;
    }

    private void loadAdvancedOptionPreferences() {
        this.setAdvancedOptionsVisible(Preferences.isPreference("search_window_advanced_visible"));
        this.form.m_authorCB.setSelected(Preferences.isPreference("search_window_search_author"));
        this.form.m_authorField.setText(Preferences.getPreference("search_window_author_name"));
        try {
            this.form.m_dateFromCB.setSelected(Preferences.isPreference("search_window_date_from"));
            String dateFromValue = Preferences.getPreference("search_window_date_from_value");
            if (!StringUtil.isEmpty(dateFromValue)) {
                this.dateFromModel.setValue(this.dateFormat.parse(dateFromValue));
            }
            this.form.m_dateToCB.setSelected(Preferences.isPreference("search_window_date_to"));
            String dateToValue = Preferences.getPreference("search_window_date_to_value");
            if (!StringUtil.isEmpty(dateToValue)) {
                this.dateToModel.setValue(this.dateFormat.parse(dateToValue));
            }
        }
        catch (ParseException e) {
            this.form.m_dateFromCB.setSelected(false);
            this.form.m_dateToCB.setSelected(false);
        }
        this.form.m_numberOfResults.setValue(Preferences.getPreferenceDefault("search_window_number_of_results", 1000));
        this.form.m_excludeOrphans.setSelected(Preferences.isPreference("search_window_exclude_orphans"));
        this.form.m_fullHalfWidthInsensitive.setSelected(Preferences.isPreference("search_window_full_half_width_insensitive"));
        if (this.form.m_authorCB.isSelected() || this.form.m_dateFromCB.isSelected() || this.form.m_dateToCB.isSelected() || this.form.m_excludeOrphans.isSelected() || this.form.m_fullHalfWidthInsensitive.isSelected()) {
            this.setAdvancedOptionsVisible(true);
        }
    }

    private void updateAdvancedOptionStatus() {
        this.form.m_authorField.setEditable(this.form.m_authorCB.isSelected());
        this.form.m_dateFromSpinner.setEnabled(this.form.m_dateFromCB.isSelected());
        this.form.m_dateFromButton.setEnabled(this.form.m_dateFromCB.isSelected());
        this.form.m_dateToSpinner.setEnabled(this.form.m_dateToCB.isSelected());
        this.form.m_dateToButton.setEnabled(this.form.m_dateToCB.isSelected());
    }

    private void setEnabled(Container component, boolean enabled) {
        component.setEnabled(enabled);
        for (int i = 0; i < component.getComponentCount(); ++i) {
            Component c = component.getComponent(i);
            c.setEnabled(enabled);
            if (!(c instanceof Container)) continue;
            this.setEnabled((Container)c, enabled);
        }
    }

    private IEditor.CaretPosition getCurrentPositionInEntryTranslationInEditor(IEditor editor) {
        if (editor instanceof EditorController) {
            EditorController c = (EditorController)editor;
            int selectionEnd = c.getCurrentPositionInEntryTranslation();
            String selection = c.getSelectedText();
            String translation = c.getCurrentTranslation();
            if (StringUtil.isEmpty(translation) || StringUtil.isEmpty(selection)) {
                return new IEditor.CaretPosition(selectionEnd);
            }
            int selectionStart = selectionEnd;
            int pos = 0;
            do {
                if ((pos = translation.indexOf(selection, pos)) == selectionEnd) {
                    selectionStart = pos;
                    selectionEnd = pos + selection.length();
                    break;
                }
                if (pos + selection.length() != selectionEnd) continue;
                selectionStart = pos;
                break;
            } while (++pos > 0);
            return new IEditor.CaretPosition(selectionStart, selectionEnd);
        }
        return IEditor.CaretPosition.startOfEntry();
    }

    public void addWindowListener(WindowListener listener) {
        this.form.addWindowListener(listener);
    }

    public void displayErrorRB(Throwable ex, String errorKey, Object ... params) {
        UIThreadsUtil.executeInSwingThread(() -> {
            String msg = params != null ? StringUtil.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
            String fulltext = msg;
            if (ex != null) {
                fulltext = fulltext + "\n" + ex.getLocalizedMessage();
            }
            JOptionPane.showMessageDialog(this.form, fulltext, OStrings.getString("TF_ERROR"), 0);
        });
    }
}

