/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.UIThreadsUtil;

public abstract class AlphabeticalMarkers
extends JPanel {
    private static final String DEFAULT_MARKER_FONT_NAME = "Century";
    private static final int FIRST_TITLE_LETTER = 97;
    private final ColorScheme colorScheme;
    private final Font titleFont = AlphabeticalMarkers.getTitleFont();
    private final int boxSize = AlphabeticalMarkers.getBoxSize(this.titleFont);
    private final Polygon markerShape = AlphabeticalMarkers.createMarkerShape(this.boxSize);
    private final Rectangle guidingSquare = new Rectangle(this.boxSize, this.boxSize);
    private List<Marker> markers = null;
    private final JLayeredPane parent = Core.getMainWindow().getApplicationFrame().getLayeredPane();
    private final JScrollPane scrollPane;
    private final boolean sourceLangIsRTL;

    AlphabeticalMarkers(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        String sourceLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        this.sourceLangIsRTL = EditorUtils.isRTL(sourceLang);
        this.colorScheme = this.createColorScheme(scrollPane.getViewport().getView().getBackground());
    }

    private ColorScheme createColorScheme(Color editorBackground) {
        int minimumVisibility = 32768;
        int distanceToLightScheme = this.calculateSSD(editorBackground, Color.YELLOW);
        if (distanceToLightScheme >= minimumVisibility) {
            return new ColorScheme(Color.YELLOW, Color.RED, Color.ORANGE);
        }
        return new ColorScheme(Color.DARK_GRAY, Color.GREEN, Color.MAGENTA);
    }

    private int calculateSSD(Color a, Color b) {
        int db = a.getBlue() - b.getBlue();
        int dg = a.getGreen() - b.getGreen();
        int dr = a.getRed() - b.getRed();
        return db * db + dg * dg + dr * dr;
    }

    @Override
    public void paint(Graphics g) {
        try {
            Point srcLocation = new Point(0, 0);
            Point dstLocation = SwingUtilities.convertPoint(this.scrollPane, srcLocation, this);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(dstLocation.x, dstLocation.y);
            if (!g2.getFontRenderContext().isAntiAliased()) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            for (Marker marker : this.markers) {
                this.drawMarker(g2, marker.location, String.valueOf(Character.toChars(marker.title)));
            }
            g2.dispose();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void drawMarker(Graphics2D g2, Point location, String title) {
        Point boxLocation = new Point(location);
        if (this.sourceLangIsRTL) {
            boxLocation.translate(-this.boxSize, -this.boxSize);
        } else {
            boxLocation.translate(0, -this.boxSize);
        }
        this.guidingSquare.setLocation(boxLocation);
        TextLayout layout = new TextLayout(title, this.titleFont, g2.getFontRenderContext());
        Rectangle pixelBounds = layout.getPixelBounds(null, location.x, location.y);
        Dimension diffForCentered = AlphabeticalMarkers.getCenteredDimension(pixelBounds, this.guidingSquare);
        this.markerShape.translate(boxLocation.x, boxLocation.y);
        g2.setColor(this.colorScheme.background);
        g2.fill(this.markerShape);
        g2.setColor(this.colorScheme.border);
        g2.draw(this.markerShape);
        this.markerShape.translate(-boxLocation.x, -boxLocation.y);
        g2.setColor(this.colorScheme.foreground);
        layout.draw(g2, location.x + diffForCentered.width, location.y + diffForCentered.height);
    }

    private static Polygon createMarkerShape(int boxSize) {
        Polygon poly = new Polygon();
        poly.addPoint(0, boxSize);
        poly.addPoint(boxSize / 3, boxSize);
        poly.addPoint(boxSize / 2, boxSize + boxSize / 3);
        poly.addPoint(boxSize - boxSize / 3, boxSize);
        poly.addPoint(boxSize, boxSize);
        poly.addPoint(boxSize, 0);
        poly.addPoint(0, 0);
        return poly;
    }

    private static Dimension getCenteredDimension(Rectangle target, Rectangle base) {
        double baseCenterX = base.getCenterX();
        double baseCenterY = base.getCenterY();
        double targetCenterX = target.getCenterX();
        double targetCenterY = target.getCenterY();
        double diffX = 0.0;
        double diffY = 0.0;
        if (baseCenterX != targetCenterX) {
            diffX = baseCenterX - targetCenterX;
        }
        if (baseCenterY != targetCenterY) {
            diffY = baseCenterY - targetCenterY;
        }
        return new Dimension((int)diffX, (int)diffY);
    }

    private static Font getTitleFont() {
        boolean fontAvailable = Arrays.asList(StaticUtils.getFontNames()).contains(DEFAULT_MARKER_FONT_NAME);
        String fontName = fontAvailable ? DEFAULT_MARKER_FONT_NAME : "Serif";
        int fontSize = Preferences.getPreferenceDefault("source_font_size", 12);
        return new Font(fontName, 1, fontSize);
    }

    private static int getBoxSize(Font baseFont) {
        return (int)(baseFont.getSize2D() * 1.4f);
    }

    public void showMarkers() {
        UIThreadsUtil.mustBeSwingThread();
        this.markers = AlphabeticalMarkers.createMarkers(this.getViewableSegmentLocations());
        if (this.markers.isEmpty()) {
            return;
        }
        this.setSize(this.parent.getWidth() - 1, this.parent.getHeight() - 1);
        this.parent.add(this, JLayeredPane.POPUP_LAYER, 0);
        this.parent.validate();
        this.parent.repaint();
    }

    public void hideMarkers() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.markers != null && !this.markers.isEmpty()) {
            this.parent.remove(this);
            this.parent.validate();
            this.parent.repaint();
            this.markers.clear();
        }
        this.markers = null;
    }

    private static List<Marker> createMarkers(Map<Integer, Point> map) {
        ArrayList<Marker> list = new ArrayList<Marker>();
        int title = 97;
        for (Map.Entry<Integer, Point> entry : map.entrySet()) {
            Marker marker = new Marker();
            marker.segmentNumber = entry.getKey();
            marker.location = entry.getValue();
            marker.title = title++;
            list.add(marker);
        }
        return list;
    }

    protected abstract Map<Integer, Point> getViewableSegmentLocations();

    public String translateSegmentNumber(String inputValue) {
        try {
            Marker marker = this.findMarkerByTitle(inputValue);
            return String.valueOf(marker.segmentNumber);
        }
        catch (Exception ex) {
            return inputValue;
        }
    }

    public boolean containsTitle(int title) {
        try {
            this.findMarkerByTitle(title);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Marker findMarkerByTitle(String title) {
        String trimmed = title.trim();
        if (trimmed.codePointCount(0, trimmed.length()) == 1) {
            int cp = trimmed.codePointAt(0);
            return this.findMarkerByTitle(cp);
        }
        throw new RuntimeException("Marker with the title '" + title + "' is not found");
    }

    private Marker findMarkerByTitle(int title) {
        for (Marker marker : this.markers) {
            if (title != marker.title) continue;
            return marker;
        }
        throw new RuntimeException("Marker with the title '" + String.valueOf(Character.toChars(title)) + "' is not found");
    }

    private static class ColorScheme {
        final Color background;
        final Color foreground;
        final Color border;

        ColorScheme(Color background, Color foreground, Color border) {
            this.background = background;
            this.foreground = foreground;
            this.border = border;
        }
    }

    private static class Marker {
        int segmentNumber = 0;
        Point location = null;
        int title = 0;

        private Marker() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + " {" + this.segmentNumber + ", '" + this.title + "', " + this.location.toString() + "}";
        }
    }
}

