/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class FileCollisionDialog
extends JDialog {
    private JButton userClicked;
    private JCheckBox batchCheckbox;
    private JButton cancelButton;
    private JLabel icon;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextArea message;
    private JButton replaceButton;

    public static boolean promptToReplace(JDialog parent, String filename) {
        FileCollisionDialog dialog = new FileCollisionDialog(parent);
        dialog.setFilename(filename);
        dialog.enableApplyToAll(false);
        dialog.pack();
        dialog.setVisible(true);
        return dialog.shouldReplace();
    }

    public FileCollisionDialog(Frame parent) {
        super(parent, true);
        this.grandInit();
        this.setLocationRelativeTo(parent);
    }

    public FileCollisionDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.grandInit();
        this.setLocationRelativeTo(parent);
    }

    private void grandInit() {
        this.initComponents();
        this.icon.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCollisionDialog.this.cancelButtonActionPerformed(null);
            }
        });
    }

    public void setFilename(String name) {
        this.message.setText(StringUtil.format(OStrings.getString("DND_FILE_COLLISION_MESSAGE"), name));
    }

    public void enableApplyToAll(boolean enabled) {
        this.batchCheckbox.setVisible(enabled);
    }

    public boolean isApplyToAll() {
        return this.batchCheckbox.isSelected();
    }

    public boolean userDidCancel() {
        return this.userClicked == this.cancelButton;
    }

    public boolean shouldReplace() {
        return this.userClicked == this.replaceButton;
    }

    private void close() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.icon = new JLabel();
        this.message = new JTextArea();
        this.jPanel2 = new JPanel();
        this.batchCheckbox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.replaceButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout(10, 0));
        this.jPanel3.add((Component)this.icon, "West");
        this.message.setEditable(false);
        this.message.setFont(this.icon.getFont());
        this.message.setLineWrap(true);
        this.message.setText(OStrings.getString("DND_FILE_COLLISION_MESSAGE"));
        this.message.setWrapStyleWord(true);
        this.message.setDragEnabled(false);
        this.message.setFocusable(false);
        this.message.setOpaque(false);
        this.jPanel3.add((Component)this.message, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.batchCheckbox, (String)OStrings.getString("DND_APPLY_TO_ALL_BUTTON"));
        this.jPanel2.add((Component)this.batchCheckbox, "West");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileCollisionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceButton, (String)OStrings.getString("DND_REPLACE_BUTTON"));
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileCollisionDialog.this.replaceButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.replaceButton);
        this.jPanel2.add((Component)this.jPanel1, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.userClicked = this.cancelButton;
        this.close();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        this.userClicked = this.replaceButton;
        this.close();
    }
}

