/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.model.language;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.loomchild.maligna.model.language.LanguageModel;
import net.loomchild.maligna.model.vocabulary.Vocabulary;

class MutableLanguageModel
implements LanguageModel {
    private ArrayList<Float> wordProbabilityArray = new ArrayList();
    int wordOccurenceCount = 0;
    float singletonWordProbability = 0.0f;

    @Override
    public float getWordProbability(int wid) {
        assert (wid >= 0);
        if (wid < this.wordProbabilityArray.size()) {
            return this.wordProbabilityArray.get(wid).floatValue();
        }
        return this.singletonWordProbability;
    }

    @Override
    public float getSingletonWordProbability() {
        return this.singletonWordProbability;
    }

    public void addWordOccurence(int wid) {
        this.addWordOccurence(wid, 1);
    }

    public void addWordOccurence(int wid, int count) {
        assert (wid >= 0);
        this.ensureSize(wid + 1);
        this.wordProbabilityArray.set(wid, Float.valueOf(this.wordProbabilityArray.get(wid).floatValue() + (float)count));
        this.wordOccurenceCount += count;
    }

    public void normalize() {
        for (int i = 0; i < this.wordProbabilityArray.size(); ++i) {
            float probability = this.wordProbabilityArray.get(i).floatValue() / (float)this.wordOccurenceCount;
            this.wordProbabilityArray.set(i, Float.valueOf(probability));
        }
        this.singletonWordProbability = 1.0f / (float)this.wordOccurenceCount;
    }

    private void ensureSize(int size) {
        int currentSize = this.wordProbabilityArray.size();
        if (size > currentSize) {
            this.wordProbabilityArray.ensureCapacity(size);
            for (int i = currentSize; i < size; ++i) {
                this.wordProbabilityArray.add(Float.valueOf(0.0f));
            }
        }
    }

    @Override
    public void format(Writer writer, Vocabulary vocabulary) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        for (int i = 0; i < this.wordProbabilityArray.size(); ++i) {
            printWriter.println(vocabulary.getWord(i) + "\t" + this.wordProbabilityArray.get(i));
        }
    }
}

