/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.filelist.ProjectFilesList;
import org.omegat.gui.filelist.TableFilterPanel;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.util.Java8Compat;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StreamUtil;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DataTableStyling;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;
import org.omegat.util.gui.UIThreadsUtil;

public class ProjectFilesListController {
    private ProjectFilesList list;
    private FileInfoModel modelFiles;
    private AbstractTableModel modelTotal;
    private Sorter currentSorter;
    private TableFilterPanel filterPanel;
    private Font defaultFont;
    private final KeyListener filterTrigger = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!(e.getModifiersEx() != 0 && e.getModifiersEx() != 64 || Character.isWhitespace(c) || Character.isISOControl(c))) {
                if (ProjectFilesListController.this.isFiltering()) {
                    ProjectFilesListController.this.resumeFilter(e.getKeyChar());
                } else {
                    ProjectFilesListController.this.startFilter(e.getKeyChar());
                }
                e.consume();
            }
        }
    };
    ActionListener moveAction = e -> {
        int newPos;
        int[] selected = this.list.tableFiles.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        int pos = selected[0];
        if (e.getSource() == this.list.btnUp) {
            newPos = pos - 1;
        } else if (e.getSource() == this.list.btnDown) {
            newPos = pos + 1;
        } else if (e.getSource() == this.list.btnFirst) {
            newPos = 0;
        } else if (e.getSource() == this.list.btnLast) {
            newPos = Integer.MAX_VALUE;
        } else {
            return;
        }
        pos = this.currentSorter.moveTo(selected, newPos);
        this.list.tableFiles.getSelectionModel().setSelectionInterval(pos, pos + selected.length - 1);
    };
    private static final Color COLOR_SPECIAL_FG = Color.BLACK;
    private static final Color COLOR_SPECIAL_BG = new Color(13164018);

    public ProjectFilesListController(MainWindow parent) {
        this.list = new ProjectFilesList();
        if (Platform.isMacOSX()) {
            OSXIntegration.enableFullScreen(this.list);
        }
        this.createTableFiles();
        this.createTableTotal();
        TableColumnSizer colSizer = TableColumnSizer.autoSize(this.list.tableFiles, 0, true);
        colSizer.addColumnAdjustmentListener(e -> this.propagateTableColumns());
        DragTargetOverlay.apply(this.list.tableFiles, new DragTargetOverlay.FileDropInfo(true){

            @Override
            public String getImportDestination() {
                return Core.getProject().getProjectProperties().getSourceRoot();
            }

            @Override
            public boolean canAcceptDrop() {
                return Core.getProject().isProjectLoaded();
            }

            @Override
            public String getOverlayMessage() {
                return OStrings.getString("DND_ADD_SOURCE_FILE");
            }

            @Override
            public boolean acceptFile(File path) {
                return true;
            }

            @Override
            public Component getComponentToOverlay() {
                return ((ProjectFilesListController)ProjectFilesListController.this).list.tablesInnerPanel;
            }
        });
        this.defaultFont = this.list.tableFiles.getFont();
        if (Preferences.isPreference("project_files_use_font")) {
            String fontName = Preferences.getPreference("source_font");
            int fontSize = Integer.parseInt(Preferences.getPreference("source_font_size"));
            this.setFont(new Font(fontName, 0, fontSize));
        } else {
            this.setFont(this.defaultFont);
        }
        this.list.tablesInnerPanel.setBorder(new JScrollPane().getBorder());
        this.initWindowLayout();
        this.list.m_addNewFileButton.addActionListener(e -> this.doImportSourceFiles());
        this.list.m_wikiImportButton.addActionListener(e -> this.doWikiImport());
        this.list.m_closeButton.addActionListener(e -> this.doCancel());
        this.list.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ProjectFilesListController.this.doCancel();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                ProjectFilesListController.this.propagateTableColumns();
            }
        });
        StaticUIUtils.setEscapeAction(this.list, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFilesListController.this.doCancel();
            }
        });
        CoreEvents.registerProjectChangeListener(eventType -> {
            switch (eventType) {
                case CLOSE: {
                    this.list.tableFiles.setModel(new DefaultTableModel());
                    this.list.tableFiles.repaint();
                    this.modelTotal.fireTableDataChanged();
                    this.list.setVisible(false);
                    break;
                }
                case LOAD: 
                case CREATE: {
                    this.buildDisplay(Core.getProject().getProjectFiles());
                    if (!Preferences.isPreferenceDefault("project_files_show_on_load", true)) break;
                    this.list.setVisible(true);
                    SwingUtilities.invokeLater(() -> {
                        this.list.toFront();
                        this.list.tableFiles.requestFocus();
                    });
                    break;
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
                ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.repaint();
                ((ProjectFilesListController)ProjectFilesListController.this).list.tableTotal.repaint();
                ProjectFilesListController.this.modelTotal.fireTableDataChanged();
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                UIThreadsUtil.mustBeSwingThread();
                ProjectFilesListController.this.modelTotal.fireTableDataChanged();
            }
        });
        CoreEvents.registerFontChangedEventListener(newFont -> {
            if (!Preferences.isPreference("project_files_use_font")) {
                newFont = this.defaultFont;
            }
            this.setFont(newFont);
        });
        this.list.tableFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getModifiersEx() == 0) {
                    ProjectFilesListController.this.gotoFile(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.rowAtPoint(e.getPoint()));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e.getPoint());
                }
            }

            private void doPopup(Point p) {
                JPopupMenu popup;
                int row = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.rowAtPoint(p);
                if (row != -1 && (popup = ProjectFilesListController.this.createContextMenuForRow(row)) != null) {
                    popup.show(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles, p.x, p.y);
                }
            }
        });
        this.list.tableFiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProjectFilesListController.this.gotoFile(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow());
                    e.consume();
                } else if (ProjectFilesListController.this.isFiltering() && e.getKeyCode() == 27) {
                    ProjectFilesListController.this.endFilter();
                    e.consume();
                } else if (e.getKeyCode() == 525) {
                    int row = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow();
                    Point p = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getCellRect(row, 0, false).getLocation();
                    JPopupMenu popup = ProjectFilesListController.this.createContextMenuForRow(row);
                    if (popup != null) {
                        popup.show(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles, p.x, p.y);
                    }
                    e.consume();
                }
            }
        });
        this.list.tableFiles.getSelectionModel().addListSelectionListener(e -> this.updateButtonState());
        this.list.tableFiles.addKeyListener(this.filterTrigger);
        this.list.tableTotal.addKeyListener(this.filterTrigger);
        this.list.btnUp.addKeyListener(this.filterTrigger);
        this.list.btnDown.addKeyListener(this.filterTrigger);
        this.list.btnFirst.addKeyListener(this.filterTrigger);
        this.list.btnLast.addKeyListener(this.filterTrigger);
        this.list.btnUp.addActionListener(this.moveAction);
        this.list.btnDown.addActionListener(this.moveAction);
        this.list.btnFirst.addActionListener(this.moveAction);
        this.list.btnLast.addActionListener(this.moveAction);
    }

    private void updateTitle() {
        int numFiles = this.currentSorter.getModelRowCount();
        if (this.isFiltering()) {
            int showingFiles = this.currentSorter.getViewRowCount();
            this.list.setTitle(StringUtil.format(OStrings.getString("PF_WINDOW_TITLE_FILTERED"), showingFiles, numFiles));
        } else {
            this.list.setTitle(StringUtil.format(OStrings.getString("PF_WINDOW_TITLE"), numFiles));
        }
    }

    private void updateButtonState() {
        boolean enabled = this.list.tableFiles.getSelectedRow() != -1;
        this.list.btnDown.setEnabled(enabled);
        this.list.btnFirst.setEnabled(enabled);
        this.list.btnLast.setEnabled(enabled);
        this.list.btnUp.setEnabled(enabled);
    }

    private JPopupMenu createContextMenuForRow(int row) {
        int[] rows = IntStream.of(this.list.tableFiles.getSelectedRows()).anyMatch(r -> r == row) ? this.list.tableFiles.getSelectedRows() : new int[]{row};
        List infos = IntStream.of(rows).map(this.list.tableFiles.getRowSorter()::convertRowIndexToModel).mapToObj(this.modelFiles::getDataAtRow).collect(Collectors.toList());
        if (infos.isEmpty() || infos.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        String sourceDir = Core.getProject().getProjectProperties().getSourceRoot();
        String targetDir = Core.getProject().getProjectProperties().getTargetRoot();
        JPopupMenu menu = new JPopupMenu();
        this.addContextMenuItem(menu, true, infos.stream().map(i -> new File(sourceDir, i.filePath)).collect(Collectors.toList()));
        this.addContextMenuItem(menu, false, infos.stream().map(i -> new File(targetDir, Core.getProject().getTargetPathForSourceFile(i.filePath))).collect(Collectors.toList()));
        return menu;
    }

    private void addContextMenuItem(final JPopupMenu menu, boolean isSource, List<File> files) {
        String modTitle;
        String defaultTitle;
        long presentFiles = files.stream().filter(File::isFile).count();
        if (presentFiles > 1L) {
            defaultTitle = StringUtil.format(OStrings.getString(isSource ? "PF_OPEN_SOURCE_FILES" : "PF_OPEN_TARGET_FILES"), presentFiles);
            modTitle = StringUtil.format(OStrings.getString(isSource ? "PF_OPEN_SOURCE_FILES" : "PF_OPEN_TARGET_FILES"), presentFiles);
        } else {
            defaultTitle = OStrings.getString(isSource ? "PF_OPEN_SOURCE_FILE" : "PF_OPEN_TARGET_FILE");
            modTitle = OStrings.getString(isSource ? "PF_REVEAL_SOURCE_FILE" : "PF_REVEAL_TARGET_FILE");
        }
        final JMenuItem item = menu.add(defaultTitle);
        item.addActionListener(e -> {
            boolean openParent = (e.getModifiers() & Java8Compat.getMenuShortcutKeyMaskEx()) != 0;
            Stream<File> stream = openParent ? files.stream().map(File::getParentFile).distinct().filter(File::isDirectory) : files.stream().filter(File::isFile);
            stream.forEach(f -> {
                try {
                    Desktop.getDesktop().open((File)f);
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
            });
        });
        item.setEnabled(presentFiles > 0L);
        item.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
                if ((e.getModifiersEx() & Java8Compat.getMenuShortcutKeyMaskEx()) != 0 || e.getKeyCode() == 157 || e.getKeyCode() == 17) {
                    this.setText(defaultTitle);
                }
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
                if ((e.getModifiersEx() & Java8Compat.getMenuShortcutKeyMaskEx()) != 0) {
                    this.setText(modTitle);
                }
            }

            private void setText(String text) {
                item.setText(text);
                menu.pack();
            }
        });
    }

    private void startFilter(char c) {
        if (this.isFiltering()) {
            throw new IllegalStateException("Already filtering!");
        }
        this.filterPanel = new TableFilterPanel();
        this.list.btnDown.setEnabled(false);
        this.list.btnUp.setEnabled(false);
        this.list.btnFirst.setEnabled(false);
        this.list.btnLast.setEnabled(false);
        this.list.tablesOuterPanel.add((Component)this.filterPanel, "South");
        this.filterPanel.filterTextField.addActionListener(e -> this.gotoFile(this.list.tableFiles.getSelectedRow()));
        this.filterPanel.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ProjectFilesListController.this.endFilter();
                    e.consume();
                } else if (e.getKeyCode() == 38) {
                    int selection = Math.max(0, ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow());
                    int total = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getRowCount();
                    int up = (selection - 1 + total) % total;
                    ProjectFilesListController.this.selectRow(up);
                    e.consume();
                } else if (e.getKeyCode() == 40) {
                    int selection = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getSelectedRow();
                    int down = (selection + 1) % ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getRowCount();
                    ProjectFilesListController.this.selectRow(down);
                    e.consume();
                }
            }
        });
        this.filterPanel.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectFilesListController.this.applyFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectFilesListController.this.applyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectFilesListController.this.applyFilter();
            }
        });
        this.filterPanel.filterTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((ProjectFilesListController)ProjectFilesListController.this).filterPanel.filterTextField.setCaretPosition(((ProjectFilesListController)ProjectFilesListController.this).filterPanel.filterTextField.getText().length());
            }
        });
        this.filterPanel.filterCloseButton.addActionListener(e -> this.endFilter());
        this.filterPanel.filterTextField.setText(Character.toString(c));
        this.filterPanel.filterTextField.requestFocus();
        this.list.validate();
        this.list.repaint();
    }

    private boolean isFiltering() {
        return this.filterPanel != null;
    }

    private void resumeFilter(char c) {
        if (!this.isFiltering()) {
            throw new IllegalStateException("Can't resume filtering when we're not filtering!");
        }
        try {
            this.filterPanel.filterTextField.getDocument().insertString(this.filterPanel.filterTextField.getText().length(), Character.toString(c), null);
            this.filterPanel.filterTextField.requestFocus();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void applyFilter() {
        if (!this.isFiltering()) {
            throw new IllegalStateException("Can't apply filter when we're not filtering!");
        }
        String quoted = Pattern.quote(this.filterPanel.filterTextField.getText());
        Pattern findPattern = Pattern.compile(quoted, 2);
        FilesTableColumn.FILE_NAME.setHighlightPattern(findPattern);
        Pattern matchPattern = Pattern.compile(".*" + quoted + ".*", 2);
        this.currentSorter.setFilter(matchPattern);
        this.selectRow(0);
    }

    private void endFilter() {
        if (!this.isFiltering()) {
            throw new IllegalStateException("Can't end filtering when we're not filtering!");
        }
        FilesTableColumn.FILE_NAME.setHighlightPattern(null);
        this.list.tablesOuterPanel.remove(this.filterPanel);
        this.list.btnDown.setEnabled(true);
        this.list.btnUp.setEnabled(true);
        this.list.btnFirst.setEnabled(true);
        this.list.btnLast.setEnabled(true);
        this.filterPanel = null;
        this.currentSorter.setFilter(null);
        this.list.tableFiles.requestFocus();
        int currentRow = this.list.tableFiles.getSelectedRow();
        this.list.tableFiles.scrollRectToVisible(this.list.tableFiles.getCellRect(currentRow, 0, true));
        this.list.validate();
        this.list.repaint();
    }

    public boolean isActive() {
        return this.list.isActive();
    }

    public void setActive(boolean active) {
        if (active) {
            this.list.setVisible(true);
            this.list.toFront();
            SwingUtilities.invokeLater(() -> this.selectCurrentFile(Core.getProject().getProjectFiles()));
        } else {
            this.list.setVisible(false);
        }
    }

    private void selectCurrentFile(List<IProject.FileInfo> files) {
        this.list.tableFiles.getSelectionModel().clearSelection();
        String currentFile = Core.getEditor().getCurrentFile();
        for (int i = 0; i < files.size(); ++i) {
            if (!files.get((int)i).filePath.equals(currentFile)) continue;
            int pos = this.list.tableFiles.convertRowIndexToView(i);
            this.selectRow(pos);
            break;
        }
        this.list.tableFiles.requestFocus();
    }

    private void selectRow(int row) {
        this.list.tableFiles.getSelectionModel().setSelectionInterval(row, row);
        this.list.tableFiles.scrollRectToVisible(this.list.tableFiles.getCellRect(row, 0, true));
    }

    private void initWindowLayout() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.list.setBounds((screenSize.width - 640) / 2, (screenSize.height - 400) / 2, 640, 400);
        StaticUIUtils.persistGeometry(this.list, "project_files_window");
    }

    private void doCancel() {
        this.list.setVisible(false);
    }

    private void buildDisplay(List<IProject.FileInfo> files) {
        String path;
        UIThreadsUtil.mustBeSwingThread();
        String statFileName = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats.txt";
        File statFile = new File(statFileName);
        try {
            path = statFile.getCanonicalPath();
        }
        catch (IOException ex) {
            path = statFile.getAbsolutePath();
        }
        String statText = MessageFormat.format(OStrings.getString("PF_STAT_PATH"), path);
        this.list.statLabel.setText(statText);
        this.uiUpdateImportButtonStatus();
        OSXIntegration.setProxyIcon(this.list.getRootPane(), new File(Core.getProject().getProjectProperties().getSourceRoot()));
        this.setTableFilesModel(files);
        this.updateTitle();
    }

    private void createTableFiles() {
        DataTableStyling.applyColors(this.list.tableFiles);
        this.list.tableFiles.setSelectionMode(2);
    }

    private void propagateTableColumns() {
        JScrollBar scrollbar = this.list.scrollFiles.getVerticalScrollBar();
        int sbWidth = scrollbar == null || !scrollbar.isVisible() ? 0 : scrollbar.getWidth();
        this.list.tableTotal.getColumnModel().getColumn(TotalsTableColumn.MARGIN.index).setPreferredWidth(sbWidth);
        for (int i = 0; i < this.list.tableFiles.getColumnCount(); ++i) {
            TableColumn srcCol = this.list.tableFiles.getColumnModel().getColumn(i);
            TableColumn trgCol = this.list.tableTotal.getColumnModel().getColumn(i);
            trgCol.setPreferredWidth(srcCol.getWidth());
        }
    }

    private void setTableFilesModel(List<IProject.FileInfo> files) {
        this.modelFiles = new FileInfoModel(files);
        this.list.tableFiles.setModel(this.modelFiles);
        TableColumnModel colModel = this.list.tableFiles.getColumnModel();
        colModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                ((ProjectFilesListController)ProjectFilesListController.this).list.tableTotal.getColumnModel().moveColumn(e.getFromIndex(), e.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        for (FilesTableColumn col : FilesTableColumn.values()) {
            TableColumn tCol = colModel.getColumn(col.index);
            tCol.setCellRenderer(new CustomRenderer(files, col.renderer));
        }
        this.currentSorter = new Sorter(files);
        this.currentSorter.addRowSorterListener(e -> this.updateTitle());
        this.list.tableFiles.setRowSorter(this.currentSorter);
    }

    private void createTableTotal() {
        DataTableStyling.applyColors(this.list.tableTotal);
        this.list.tableTotal.setBorder(new MatteBorder(1, 0, 0, 0, DataTableStyling.COLOR_ALTERNATING_HILITE));
        this.modelTotal = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return TotalsTableColumn.get(columnIndex).getValue(rowIndex);
            }

            @Override
            public int getColumnCount() {
                return TotalsTableColumn.values().length;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return TotalsTableColumn.get(columnIndex).clazz;
            }

            @Override
            public int getRowCount() {
                return 3;
            }
        };
        this.list.tableTotal.setModel(this.modelTotal);
        TableColumnModel colModel = this.list.tableTotal.getColumnModel();
        for (TotalsTableColumn col : TotalsTableColumn.values()) {
            TableColumn tCol = colModel.getColumn(col.index);
            tCol.setCellRenderer(new CustomRenderer(null, col.renderer));
            tCol.setMinWidth(0);
        }
    }

    private void doImportSourceFiles() {
        ProjectUICommands.doPromptImportSourceFiles();
    }

    private void doWikiImport() {
        ProjectUICommands.doWikiImport();
    }

    private void uiUpdateImportButtonStatus() {
        this.list.m_addNewFileButton.setEnabled(Core.getProject().isProjectLoaded());
        this.list.m_wikiImportButton.setEnabled(Core.getProject().isProjectLoaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoFile(int row) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (row < 0) {
            return;
        }
        Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
        Cursor oldCursor = this.list.getCursor();
        this.list.setCursor(hourglassCursor);
        try {
            int modelRow = this.list.tableFiles.convertRowIndexToModel(row);
            Core.getEditor().gotoFile(modelRow);
            Core.getEditor().requestFocus();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.list.setCursor(oldCursor);
        }
    }

    private void setFont(Font font) {
        DataTableStyling.applyFont(this.list.tableFiles, font);
        DataTableStyling.applyFont(this.list.tableTotal, font.deriveFont(1));
        this.list.statLabel.setFont(font);
    }

    class Sorter
    extends RowSorter<FileInfoModel> {
        private final List<IProject.FileInfo> files;
        private RowSorter.SortKey sortKey = new RowSorter.SortKey(0, SortOrder.UNSORTED);
        private Integer[] modelToView;
        private List<Integer> viewToModel;
        private Pattern filter;

        Sorter(List<IProject.FileInfo> files) {
            this.files = files;
            this.init();
            this.applyPrefs();
        }

        private void init() {
            int i;
            if (this.modelToView == null || this.modelToView.length != this.files.size()) {
                this.modelToView = new Integer[this.files.size()];
            }
            int excluded = 0;
            for (i = 0; i < this.modelToView.length; ++i) {
                if (this.include(this.files.get(i))) {
                    this.modelToView[i] = i - excluded;
                    continue;
                }
                this.modelToView[i] = -1;
                ++excluded;
            }
            this.viewToModel = new ArrayList<Integer>(this.modelToView.length - excluded);
            int j = 0;
            for (i = 0; i < this.modelToView.length; ++i) {
                if (this.modelToView[i] == -1) continue;
                this.viewToModel.add(j++, i);
            }
        }

        private void applyPrefs() {
            List filenames = this.files.stream().map(fi -> fi.filePath).sorted(StreamUtil.comparatorByList(Core.getProject().getSourceFilesOrder())).collect(Collectors.toList());
            Collections.sort(this.viewToModel, (o1, o2) -> {
                int pos2;
                int pos1 = filenames.indexOf(this.files.get((int)o1.intValue()).filePath);
                if (pos1 < (pos2 = filenames.indexOf(this.files.get((int)o2.intValue()).filePath))) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                return 0;
            });
            this.recalc();
        }

        @Override
        public int getModelRowCount() {
            return this.files.size();
        }

        @Override
        public int getViewRowCount() {
            return this.viewToModel.size();
        }

        @Override
        public FileInfoModel getModel() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void modelStructureChanged() {
        }

        @Override
        public void allRowsChanged() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void rowsInserted(int firstRow, int endRow) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow, int column) {
        }

        @Override
        public void rowsDeleted(int firstRow, int endRow) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return Arrays.asList(this.sortKey);
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void toggleSortOrder(int column) {
            SortOrder order = SortOrder.ASCENDING;
            if (this.sortKey.getSortOrder() == SortOrder.ASCENDING) {
                order = SortOrder.DESCENDING;
            }
            this.sortKey = new RowSorter.SortKey(column, order);
            this.sort();
            this.save();
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return this.viewToModel.get(index);
        }

        @Override
        public int convertRowIndexToView(int index) {
            return this.modelToView[index];
        }

        void sort() {
            if (this.sortKey.getSortOrder() == SortOrder.UNSORTED) {
                this.applyPrefs();
                return;
            }
            StatisticsInfo stat = Core.getProject().getStatistics();
            Collections.sort(this.viewToModel, (o1, o2) -> {
                IProject.FileInfo f1 = this.files.get((int)o1);
                IProject.FileInfo f2 = this.files.get((int)o2);
                int c = 0;
                switch (this.sortKey.getColumn()) {
                    case 0: {
                        c = f1.filePath.compareToIgnoreCase(f2.filePath);
                        break;
                    }
                    case 1: {
                        c = f1.filterFileFormatName.compareToIgnoreCase(f2.filterFileFormatName);
                        break;
                    }
                    case 2: {
                        String fe1 = f1.fileEncoding == null ? "" : f1.fileEncoding;
                        String fe2 = f2.fileEncoding == null ? "" : f2.fileEncoding;
                        c = fe1.compareToIgnoreCase(fe2);
                        break;
                    }
                    case 3: {
                        int m1 = f1.entries.size();
                        int m2 = f2.entries.size();
                        c = m1 > m2 ? 1 : (m1 < m2 ? -1 : 0);
                        break;
                    }
                    case 4: {
                        int n1 = stat.uniqueCountsByFile.get(f1.filePath);
                        int n2 = stat.uniqueCountsByFile.get(f2.filePath);
                        int n = n1 > n2 ? 1 : (c = n1 < n2 ? -1 : 0);
                    }
                }
                if (this.sortKey.getSortOrder() == SortOrder.DESCENDING) {
                    c = -c;
                }
                return c;
            });
            this.recalc();
        }

        private void recalc() {
            for (int i = 0; i < this.viewToModel.size(); ++i) {
                this.modelToView[this.viewToModel.get((int)i).intValue()] = i;
            }
        }

        public int moveTo(int[] selected, int newPos) {
            int i;
            int[] temp = new int[selected.length];
            int n = selected.length;
            for (i = 0; i < selected.length; ++i) {
                temp[i] = this.viewToModel.remove(selected[--n]);
            }
            newPos = Math.max(newPos, 0);
            newPos = Math.min(newPos, this.viewToModel.size());
            for (i = 0; i < temp.length; ++i) {
                this.viewToModel.add(newPos, temp[i]);
            }
            this.recalc();
            this.save();
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.scrollRectToVisible(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getCellRect(newPos, 0, true).union(((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getCellRect(newPos + temp.length, 0, true)));
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.repaint();
            this.sortKey = new RowSorter.SortKey(0, SortOrder.UNSORTED);
            ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.getTableHeader().repaint();
            return newPos;
        }

        private void save() {
            ArrayList<String> filenames = new ArrayList<String>();
            for (Integer i : this.viewToModel) {
                String fn = this.files.get((int)i.intValue()).filePath;
                filenames.add(fn);
            }
            Core.getProject().setSourceFilesOrder(filenames);
        }

        public void setFilter(Pattern pattern) {
            if (this.filter == pattern || pattern != null && pattern.equals(this.filter)) {
                return;
            }
            this.filter = pattern;
            int[] lastViewToModel = this.viewToModel.stream().mapToInt(Integer::intValue).toArray();
            this.init();
            this.sort();
            this.fireRowSorterChanged(lastViewToModel);
        }

        private boolean include(IProject.FileInfo item) {
            if (this.filter == null) {
                return true;
            }
            return this.filter.matcher(item.filePath).matches();
        }
    }

    static class FileInfoModel
    extends AbstractTableModel {
        private final List<IProject.FileInfo> files;

        FileInfoModel(List<IProject.FileInfo> files) {
            this.files = files;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            IProject.FileInfo fi;
            try {
                fi = this.files.get(rowIndex);
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
            switch (FilesTableColumn.get(columnIndex)) {
                case FILE_NAME: {
                    return fi.filePath;
                }
                case FILTER: {
                    return fi.filterFileFormatName;
                }
                case ENCODING: {
                    return fi.fileEncoding;
                }
                case SEGMENTS: {
                    return fi.entries.size();
                }
                case UNIQUE_SEGMENTS: {
                    StatisticsInfo stat = Core.getProject().getStatistics();
                    return stat.uniqueCountsByFile.get(fi.filePath);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getColumnCount() {
            return FilesTableColumn.values().length;
        }

        @Override
        public int getRowCount() {
            return this.files.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return FilesTableColumn.get(columnIndex).clazz;
        }

        @Override
        public String getColumnName(int column) {
            return FilesTableColumn.get(column).label;
        }

        public IProject.FileInfo getDataAtRow(int row) {
            return row >= 0 && row < this.files.size() ? this.files.get(row) : null;
        }
    }

    private class CustomRenderer
    implements TableCellRenderer {
        private final List<IProject.FileInfo> files;
        private final TableCellRenderer childRenderer;

        CustomRenderer(List<IProject.FileInfo> files, TableCellRenderer childRenderer) {
            this.files = files;
            this.childRenderer = childRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.childRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected && this.isSpecialHighlightRow(row)) {
                c.setForeground(COLOR_SPECIAL_FG);
                c.setBackground(COLOR_SPECIAL_BG);
            }
            return c;
        }

        private boolean isSpecialHighlightRow(int row) {
            if (this.files == null) {
                return false;
            }
            try {
                int modelRow = ((ProjectFilesListController)ProjectFilesListController.this).list.tableFiles.convertRowIndexToModel(row);
                IProject.FileInfo fi = this.files.get(modelRow);
                return fi.filePath.equals(Core.getEditor().getCurrentFile());
            }
            catch (IndexOutOfBoundsException ex) {
                return false;
            }
        }
    }

    static enum TotalsTableColumn {
        LABEL(0, (Class)String.class, DataTableStyling.getTextCellRenderer()){

            @Override
            protected Object getValue(int row) {
                switch (row) {
                    case 0: {
                        return OStrings.getString("GUI_PROJECT_TOTAL_SEGMENTS");
                    }
                    case 1: {
                        return OStrings.getString("GUI_PROJECT_UNIQUE_SEGMENTS");
                    }
                    case 2: {
                        return OStrings.getString("GUI_PROJECT_TRANSLATED");
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        ,
        EMPTY_1(1, String.class, DataTableStyling.getTextCellRenderer()),
        EMPTY_2(2, String.class, DataTableStyling.getTextCellRenderer()),
        EMPTY_3(3, Integer.class, DataTableStyling.getNumberCellRenderer()),
        VALUE(4, (Class)Integer.class, DataTableStyling.getNumberCellRenderer()){

            @Override
            protected Object getValue(int row) {
                if (!Core.getProject().isProjectLoaded()) {
                    return "-";
                }
                StatisticsInfo stat = Core.getProject().getStatistics();
                switch (row) {
                    case 0: {
                        return stat.numberOfSegmentsTotal;
                    }
                    case 1: {
                        return stat.numberOfUniqueSegments;
                    }
                    case 2: {
                        return stat.numberofTranslatedSegments;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        ,
        MARGIN(5, String.class, new DataTableStyling.AlternatingHighlightRenderer().setDoHighlight(false));

        private final int index;
        private final Class<?> clazz;
        private final TableCellRenderer renderer;

        private TotalsTableColumn(int index, Class<?> clazz, TableCellRenderer renderer) {
            this.index = index;
            this.clazz = clazz;
            this.renderer = renderer;
        }

        protected Object getValue(int row) {
            return "";
        }

        static TotalsTableColumn get(int index) {
            return TotalsTableColumn.values()[index];
        }
    }

    static enum FilesTableColumn {
        FILE_NAME(0, OStrings.getString("PF_FILENAME"), String.class, new DataTableStyling.PatternHighlightRenderer(false)),
        FILTER(1, OStrings.getString("PF_FILTERNAME"), String.class, DataTableStyling.getTextCellRenderer()),
        ENCODING(2, OStrings.getString("PF_ENCODING"), String.class, DataTableStyling.getTextCellRenderer()),
        SEGMENTS(3, OStrings.getString("PF_NUM_SEGMENTS"), Integer.class, DataTableStyling.getNumberCellRenderer()),
        UNIQUE_SEGMENTS(4, OStrings.getString("PF_NUM_UNIQUE_SEGMENTS"), Integer.class, DataTableStyling.getNumberCellRenderer());

        private final int index;
        private final String label;
        private final Class<?> clazz;
        private final TableCellRenderer renderer;

        private FilesTableColumn(int index, String label, Class<?> clazz, TableCellRenderer renderer) {
            this.index = index;
            this.label = label;
            this.clazz = clazz;
            this.renderer = renderer;
        }

        static FilesTableColumn get(int index) {
            return FilesTableColumn.values()[index];
        }

        private void setHighlightPattern(Pattern pattern) {
            if (!(this.renderer instanceof DataTableStyling.PatternHighlightRenderer)) {
                throw new UnsupportedOperationException("Column " + this.label + " doesn't support pattern highlights");
            }
            ((DataTableStyling.PatternHighlightRenderer)this.renderer).setPattern(pattern);
        }
    }
}

