/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.gui;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.omegat.externalfinder.gui.ExternalFinderItemCommandEditorController;
import org.omegat.externalfinder.gui.ExternalFinderItemEditorPanel;
import org.omegat.externalfinder.gui.ExternalFinderItemURLEditorController;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemCommand;
import org.omegat.externalfinder.item.ExternalFinderItemURL;
import org.omegat.gui.dialogs.KeyStrokeEditorDialog;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;

public class ExternalFinderItemEditorController {
    private static final int MAX_ROW_COUNT = 5;
    private final ExternalFinderItemEditorPanel panel;
    private final ExternalFinderItem.Builder builder;
    private boolean userDidConfirm;

    public ExternalFinderItemEditorController(ExternalFinderItem.SCOPE scope) {
        this(new ExternalFinderItem.Builder().setScope(scope));
    }

    public ExternalFinderItemEditorController(ExternalFinderItem item) {
        this(ExternalFinderItem.Builder.from(item));
    }

    public ExternalFinderItemEditorController(ExternalFinderItem.Builder builder) {
        this.builder = builder;
        this.panel = new ExternalFinderItemEditorPanel();
    }

    public boolean show(Window parent) {
        JDialog dialog = new JDialog(parent, OStrings.getString("EXTERNALFINDER_EDITOR_TITLE"));
        dialog.setModal(true);
        dialog.getContentPane().add(this.panel);
        dialog.setDefaultCloseOperation(2);
        StaticUIUtils.setWindowIcon(dialog);
        StaticUIUtils.setEscapeClosable(dialog);
        this.panel.nameField.setText(this.builder.getName());
        this.panel.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                ExternalFinderItemEditorController.this.builder.setName(((ExternalFinderItemEditorController)ExternalFinderItemEditorController.this).panel.nameField.getText().trim());
                ExternalFinderItemEditorController.this.validate();
            }
        });
        this.panel.setKeystrokeButton.addActionListener(e -> this.editKeyStroke());
        this.updateKeyStroke();
        this.panel.popupCheckBox.setSelected(!this.builder.isNopopup());
        this.panel.popupCheckBox.addActionListener(e -> this.builder.setNopopup(!this.panel.popupCheckBox.isSelected()));
        this.panel.addUrlButton.addActionListener(e -> this.addUrl());
        this.panel.removeUrlButton.addActionListener(e -> this.removeSelectedUrl());
        this.panel.editUrlButton.addActionListener(e -> this.editSelectedUrl());
        this.panel.urlsTable.setModel(new UrlsTableModel());
        this.panel.urlsTable.getSelectionModel().addListSelectionListener(e -> this.onUrlSelectionChanged());
        Dimension tableSize = this.panel.urlsTable.getPreferredSize();
        this.panel.urlsTable.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.panel.urlsTable.getRowHeight() * 5));
        TableColumnSizer.autoSize(this.panel.urlsTable, UrlColumn.URL.index, true);
        this.panel.urlsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ExternalFinderItemEditorController.this.editSelectedUrl();
                }
            }
        });
        this.panel.addCommandButton.addActionListener(e -> this.addCommand());
        this.panel.removeCommandButton.addActionListener(e -> this.removeSelectedCommand());
        this.panel.editCommandButton.addActionListener(e -> this.editSelectedCommand());
        this.panel.commandsTable.setModel(new CommandsTableModel());
        this.panel.commandsTable.getSelectionModel().addListSelectionListener(e -> this.onCommandSelectionChanged());
        tableSize = this.panel.commandsTable.getPreferredSize();
        this.panel.commandsTable.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.panel.commandsTable.getRowHeight() * 5));
        TableColumnSizer.autoSize(this.panel.commandsTable, CommandColumn.COMMAND.index, true);
        this.panel.commandsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ExternalFinderItemEditorController.this.editSelectedCommand();
                }
            }
        });
        this.panel.okButton.addActionListener(e -> {
            if (this.validate()) {
                this.userDidConfirm = true;
                StaticUIUtils.closeWindowByEvent(dialog);
            }
        });
        dialog.getRootPane().setDefaultButton(this.panel.okButton);
        this.panel.cancelButton.addActionListener(e -> {
            this.userDidConfirm = false;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        this.onUrlSelectionChanged();
        this.onCommandSelectionChanged();
        this.validate();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.userDidConfirm;
    }

    public ExternalFinderItem getResult() {
        return this.builder.build();
    }

    private boolean validate() {
        boolean isValid = true;
        try {
            this.builder.validate();
        }
        catch (Exception e) {
            isValid = false;
        }
        this.panel.okButton.setEnabled(isValid);
        return isValid;
    }

    private void editKeyStroke() {
        KeyStrokeEditorDialog dialog = new KeyStrokeEditorDialog(this.builder.getKeyStroke());
        if (dialog.show(SwingUtilities.windowForComponent(this.panel))) {
            this.builder.setKeyStroke(dialog.getResult());
            this.updateKeyStroke();
        }
    }

    private void updateKeyStroke() {
        KeyStroke ks = this.builder.getKeyStroke();
        String text = ks == null ? OStrings.getString("KEYSTROKE_EDITOR_NOT_SET") : StaticUIUtils.getKeyStrokeText(ks);
        this.panel.keystrokeLabel.setText(text);
    }

    private void addUrl() {
        ExternalFinderItemURLEditorController editor = new ExternalFinderItemURLEditorController();
        if (editor.show(SwingUtilities.windowForComponent(this.panel))) {
            int row = this.panel.urlsTable.getSelectedRow();
            int newRow = row >= 0 ? row + 1 : this.builder.getURLs().size();
            this.builder.getURLs().add(newRow, editor.getResult());
            this.panel.urlsTable.repaint();
            this.panel.urlsTable.setRowSelectionInterval(newRow, newRow);
            this.validate();
        }
    }

    private void removeSelectedUrl() {
        int row = this.panel.urlsTable.getSelectedRow();
        if (row >= 0) {
            this.builder.getURLs().remove(row);
            this.panel.urlsTable.repaint();
            this.validate();
        }
    }

    private void editSelectedUrl() {
        ExternalFinderItemURL url;
        ExternalFinderItemURLEditorController editor;
        int row = this.panel.urlsTable.getSelectedRow();
        if (row >= 0 && (editor = new ExternalFinderItemURLEditorController(url = this.builder.getURLs().get(row))).show(SwingUtilities.windowForComponent(this.panel))) {
            this.builder.getURLs().set(row, editor.getResult());
            this.panel.urlsTable.repaint();
            this.validate();
        }
    }

    private void addCommand() {
        ExternalFinderItemCommandEditorController editor = new ExternalFinderItemCommandEditorController();
        if (editor.show(SwingUtilities.windowForComponent(this.panel))) {
            int row = this.panel.commandsTable.getSelectedRow();
            int newRow = row >= 0 ? row + 1 : this.builder.getCommands().size();
            this.builder.getCommands().add(newRow, editor.getResult());
            this.panel.commandsTable.repaint();
            this.panel.commandsTable.setRowSelectionInterval(newRow, newRow);
            this.validate();
        }
    }

    private void removeSelectedCommand() {
        int row = this.panel.commandsTable.getSelectedRow();
        if (row >= 0) {
            this.builder.getCommands().remove(row);
            this.panel.commandsTable.repaint();
            this.validate();
        }
    }

    private void editSelectedCommand() {
        ExternalFinderItemCommand command;
        ExternalFinderItemCommandEditorController editor;
        int row = this.panel.commandsTable.getSelectedRow();
        if (row >= 0 && (editor = new ExternalFinderItemCommandEditorController(command = this.builder.getCommands().get(row))).show(SwingUtilities.windowForComponent(this.panel))) {
            this.builder.getCommands().set(row, editor.getResult());
            this.panel.commandsTable.repaint();
            this.validate();
        }
    }

    private void onUrlSelectionChanged() {
        int row = this.panel.urlsTable.getSelectedRow();
        boolean enabled = row >= 0;
        this.panel.removeUrlButton.setEnabled(enabled);
        this.panel.editUrlButton.setEnabled(enabled);
    }

    private void onCommandSelectionChanged() {
        int row = this.panel.commandsTable.getSelectedRow();
        boolean enabled = row >= 0;
        this.panel.removeCommandButton.setEnabled(enabled);
        this.panel.editCommandButton.setEnabled(enabled);
    }

    class CommandsTableModel
    extends AbstractTableModel {
        CommandsTableModel() {
        }

        @Override
        public int getRowCount() {
            return ExternalFinderItemEditorController.this.builder.getCommands().size();
        }

        @Override
        public int getColumnCount() {
            return CommandColumn.values().length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (CommandColumn.get(columnIndex)) {
                case COMMAND: {
                    return ExternalFinderItemEditorController.this.builder.getCommands().get(rowIndex).getCommand();
                }
                case TARGET: {
                    return ExternalFinderItemEditorController.this.builder.getCommands().get(rowIndex).getTarget();
                }
                case ENCODING: {
                    return ExternalFinderItemEditorController.this.builder.getCommands().get(rowIndex).getEncoding();
                }
                case DELIMITER: {
                    return ExternalFinderItemEditorController.this.builder.getCommands().get(rowIndex).getDelimiter();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int column) {
            return CommandColumn.get((int)column).label;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return CommandColumn.get((int)columnIndex).clazz;
        }
    }

    static enum CommandColumn {
        COMMAND(0, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_COMMAND"), String.class),
        TARGET(1, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_TARGET"), ExternalFinderItem.TARGET.class),
        ENCODING(2, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_ENCODING"), ExternalFinderItem.ENCODING.class),
        DELIMITER(3, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_DELIMITER"), String.class);

        final int index;
        final String label;
        final Class<?> clazz;

        private CommandColumn(int index, String label, Class<?> clazz) {
            this.index = index;
            this.label = label;
            this.clazz = clazz;
        }

        static CommandColumn get(int index) {
            return CommandColumn.values()[index];
        }
    }

    class UrlsTableModel
    extends AbstractTableModel {
        UrlsTableModel() {
        }

        @Override
        public int getRowCount() {
            return ExternalFinderItemEditorController.this.builder.getURLs().size();
        }

        @Override
        public int getColumnCount() {
            return UrlColumn.values().length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (UrlColumn.get(columnIndex)) {
                case URL: {
                    return ExternalFinderItemEditorController.this.builder.getURLs().get(rowIndex).getURL();
                }
                case TARGET: {
                    return ExternalFinderItemEditorController.this.builder.getURLs().get(rowIndex).getTarget();
                }
                case ENCODING: {
                    return ExternalFinderItemEditorController.this.builder.getURLs().get(rowIndex).getEncoding();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int column) {
            return UrlColumn.get((int)column).label;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return UrlColumn.get((int)columnIndex).clazz;
        }
    }

    static enum UrlColumn {
        URL(0, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_URL"), String.class),
        TARGET(1, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_TARGET"), ExternalFinderItem.TARGET.class),
        ENCODING(2, OStrings.getString("EXTERNALFINDER_EDITOR_COLUMN_ENCODING"), ExternalFinderItem.ENCODING.class);

        final int index;
        final String label;
        final Class<?> clazz;

        private UrlColumn(int index, String label, Class<?> clazz) {
            this.index = index;
            this.label = label;
            this.clazz = clazz;
        }

        static UrlColumn get(int index) {
            return UrlColumn.values()[index];
        }
    }
}

