/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.omegat.util.Language;
import org.omegat.util.StringUtil;
import org.trie4j.MapTrie;
import org.trie4j.doublearray.MapDoubleArray;
import org.trie4j.patricia.MapPatriciaTrie;

public class DictionaryData<T> {
    private final Language language;
    private MapDoubleArray<Object> data;
    private MapTrie<Object> temp;

    public DictionaryData(Language language) {
        this.language = language;
        this.temp = new MapPatriciaTrie();
    }

    public void add(String key, T value) {
        key = StringUtil.normalizeUnicode(key);
        this.doAdd(key, value);
        String lowerKey = key.toLowerCase(this.language.getLocale());
        if (!key.equals(lowerKey)) {
            this.doAdd(lowerKey, value);
        }
    }

    private void doAdd(String key, T value) {
        Object[] stored = this.temp.get(key);
        if (stored == null) {
            this.temp.insert(key, value);
        } else {
            stored = stored instanceof Object[] ? this.extendArray(stored, value) : new Object[]{stored, value};
            this.temp.put(key, (Object)stored);
        }
    }

    Object[] extendArray(Object[] array, Object value) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public void done() {
        this.data = new MapDoubleArray(this.temp);
        this.temp = null;
    }

    public List<Map.Entry<String, T>> lookUp(String word) throws IllegalStateException {
        return this.doLookUpWithLowerCase(word, false);
    }

    public List<Map.Entry<String, T>> lookUpPredictive(String word) throws IllegalStateException {
        return this.doLookUpWithLowerCase(word, true);
    }

    private List<Map.Entry<String, T>> doLookUpWithLowerCase(String word, boolean predictive) {
        List<Map.Entry<String, T>> result = this.doLookUp(word, predictive);
        if (result.isEmpty()) {
            String lowerWord = word.toLowerCase(this.language.getLocale());
            result = this.doLookUp(lowerWord, predictive);
        }
        return result;
    }

    private List<Map.Entry<String, T>> doLookUp(String word, boolean predictive) throws IllegalStateException {
        if (this.data == null) {
            throw new IllegalStateException("Object has not been finalized! You must call done() before doing any lookups.");
        }
        ArrayList<Map.Entry<String, T>> result = new ArrayList<Map.Entry<String, T>>();
        if (predictive) {
            this.data.predictiveSearch(word).forEach(w -> this.get(w, this.data.get(w), result));
        } else {
            this.get(word, this.data.get(word), result);
        }
        return result;
    }

    private <U> void get(U key, Object value, Collection<Map.Entry<U, T>> into) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                into.add(new AbstractMap.SimpleImmutableEntry<U, Object>(key, o));
            }
        } else {
            into.add(new AbstractMap.SimpleImmutableEntry<U, Object>(key, value));
        }
    }

    public int size() {
        return this.data == null ? -1 : this.data.size();
    }
}

