/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.aligner.align.hmm.viterbi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.coretypes.Category;
import net.loomchild.maligna.filter.aligner.align.AlignAlgorithm;
import net.loomchild.maligna.filter.aligner.align.hmm.Util;
import net.loomchild.maligna.filter.aligner.align.hmm.viterbi.ViterbiData;
import net.loomchild.maligna.matrix.Matrix;
import net.loomchild.maligna.matrix.MatrixFactory;
import net.loomchild.maligna.matrix.MatrixIterator;
import net.loomchild.maligna.progress.ProgressManager;
import net.loomchild.maligna.progress.ProgressMeter;

public class ViterbiAlgorithm
implements AlignAlgorithm {
    private Map<Category, Float> categoryMap;
    private Calculator calculator;
    private MatrixFactory matrixFactory;

    public ViterbiAlgorithm(Calculator calculator, Map<Category, Float> categoryMap, MatrixFactory matrixFactory) {
        this.matrixFactory = matrixFactory;
        this.calculator = calculator;
        this.categoryMap = categoryMap;
    }

    @Override
    public List<Alignment> align(List<String> sourceSegmentList, List<String> targetSegmentList) {
        Matrix<ViterbiData> matrix = this.matrixFactory.createMatrix(sourceSegmentList.size() + 1, targetSegmentList.size() + 1);
        ProgressMeter progress = new ProgressMeter("Viterbi Align", matrix.getSize());
        ProgressManager.getInstance().registerProgressMeter(progress);
        MatrixIterator iterator = matrix.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            int x = iterator.getX();
            int y = iterator.getY();
            ViterbiData data = this.createData(x, y, sourceSegmentList, targetSegmentList, matrix);
            matrix.set(x, y, data);
            progress.completeTask();
        }
        List<Alignment> alignmentList = this.backtrace(sourceSegmentList, targetSegmentList, matrix);
        ProgressManager.getInstance().unregisterProgressMeter(progress);
        return alignmentList;
    }

    private ViterbiData createData(int sourceNr, int targetNr, List<String> sourceSegmentList, List<String> targetSegmentList, Matrix<ViterbiData> matrix) {
        if (sourceNr == 0 && targetNr == 0) {
            return new ViterbiData(new Category(0, 0), 0.0f, 0.0f);
        }
        Category bestCategory = null;
        float minScore = Float.POSITIVE_INFINITY;
        float minTotalScore = Float.POSITIVE_INFINITY;
        for (Map.Entry<Category, Float> entry : this.categoryMap.entrySet()) {
            List<String> targetList;
            List<String> sourceList;
            float score;
            float totalScore;
            int targetStart;
            Category category = entry.getKey();
            float categoryScore = entry.getValue().floatValue();
            int sourceStart = sourceNr - category.getSourceSegmentCount();
            if (!Util.elementExists(matrix, sourceStart, targetStart = targetNr - category.getTargetSegmentCount()) || !((totalScore = (score = categoryScore + this.calculator.calculateScore(sourceList = sourceSegmentList.subList(sourceStart, sourceNr), targetList = targetSegmentList.subList(targetStart, targetNr))) + matrix.get(sourceStart, targetStart).getTotalScore()) < minTotalScore)) continue;
            minTotalScore = totalScore;
            minScore = score;
            bestCategory = category;
        }
        if (bestCategory == null) {
            return null;
        }
        return new ViterbiData(bestCategory, minScore, minTotalScore);
    }

    private List<Alignment> backtrace(List<String> sourceSegmentList, List<String> targetSegmentList, Matrix<ViterbiData> matrix) {
        ListIterator<String> sourceIterator = sourceSegmentList.listIterator(sourceSegmentList.size());
        ListIterator<String> targetIterator = targetSegmentList.listIterator(targetSegmentList.size());
        ArrayList<Alignment> alignmentList = new ArrayList<Alignment>();
        while (sourceIterator.hasPrevious() || targetIterator.hasPrevious()) {
            ViterbiData data = matrix.get(sourceIterator.previousIndex() + 1, targetIterator.previousIndex() + 1);
            if (data == null) {
                throw new IllegalStateException("Unable to reconstruct previously calculated alignment during backtrace.");
            }
            List<String> sourceList = this.createReverseList(sourceIterator, data.getCategory().getSourceSegmentCount());
            List<String> targetList = this.createReverseList(targetIterator, data.getCategory().getTargetSegmentCount());
            Alignment alignment = new Alignment(sourceList, targetList, data.getScore());
            alignmentList.add(alignment);
        }
        Collections.reverse(alignmentList);
        return alignmentList;
    }

    private List<String> createReverseList(ListIterator<String> iterator, int count) {
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(iterator.previous());
        }
        Collections.reverse(list);
        return list;
    }
}

