/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.bits.BitUtils;
import edu.berkeley.nlp.lm.collections.LongRepresentable;

public class ProbBackoffPair
implements Comparable<ProbBackoffPair>,
LongRepresentable<ProbBackoffPair> {
    static final int MANTISSA_MASK = 0x9FFFFF;
    static final int REST_MASK = -10485760;
    public float prob;
    public float backoff;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.prob);
        result = 31 * result + Float.floatToIntBits(this.backoff);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProbBackoffPair other = (ProbBackoffPair)obj;
        if (Float.floatToIntBits(this.prob) != Float.floatToIntBits(other.prob)) {
            return false;
        }
        return Float.floatToIntBits(this.backoff) == Float.floatToIntBits(other.backoff);
    }

    public ProbBackoffPair(long probBackoff) {
        this(ProbBackoffPair.probOf(probBackoff), ProbBackoffPair.backoffOf(probBackoff));
    }

    public ProbBackoffPair(float logProb, float backoff) {
        this.prob = this.round(logProb, ConfigOptions.roundBits);
        this.backoff = this.round(backoff, ConfigOptions.roundBits);
    }

    private float round(float f, int mantissaBits) {
        int highestBit;
        if (Float.isInfinite(f)) {
            return f;
        }
        int bits = Float.floatToIntBits(f);
        int mantissa = bits & 0x9FFFFF;
        int rest = bits & 0xFF600000;
        int mask = highestBit = Integer.highestOneBit(mantissa);
        for (int i = 0; i < mantissaBits; ++i) {
            mask >>>= 1;
            mask |= highestBit;
        }
        int maskedMantissa = mantissa & mask;
        float newFloat = Float.intBitsToFloat(rest | maskedMantissa);
        assert (Float.isNaN(f) || Math.abs(f - newFloat) <= 0.001f) : "Rounding went bad for float " + f + " and rounded " + newFloat;
        return newFloat;
    }

    public String toString() {
        return "[FloatPair first=" + this.prob + ", second=" + this.backoff + "]";
    }

    @Override
    public int compareTo(ProbBackoffPair arg0) {
        int c = Float.compare(this.prob, arg0.prob);
        if (c != 0) {
            return c;
        }
        return Float.compare(this.backoff, arg0.backoff);
    }

    @Override
    public long asLong() {
        return ProbBackoffPair.floatsToLong(this.prob, this.backoff);
    }

    public static long floatsToLong(float prob, float backoff) {
        int probBits = Float.floatToIntBits(prob);
        int backoffBits = Float.floatToIntBits(backoff);
        return BitUtils.combineInts(probBits, backoffBits);
    }

    public static float probOf(long key) {
        return Float.intBitsToFloat(BitUtils.getLowInt(key));
    }

    public static float backoffOf(long key) {
        return Float.intBitsToFloat(BitUtils.getHighInt(key));
    }
}

