/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class HintTextField
extends JTextField {
    protected String hintText;
    protected Color originalForeground = this.getForeground();
    protected boolean isDirty;
    protected boolean isShowingHint;

    public HintTextField() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!HintTextField.this.isDirty) {
                    HintTextField.this.showHint();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!HintTextField.this.isDirty) {
                    HintTextField.this.hideHint();
                }
            }
        });
    }

    public void setHintText(String hintText) {
        this.hintText = hintText;
        if (!this.isDirty) {
            this.showHint();
        }
    }

    public void clear() {
        this.showHint();
    }

    public boolean isEmpty() {
        return this.isShowingHint || this.getDocument().getLength() == 0;
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        if (!this.isShowingHint) {
            this.isDirty = this.getDocument().getLength() > 0;
        }
    }

    private void showHint() {
        super.setText(this.hintText);
        this.applyHintStyle();
        this.isDirty = false;
        this.isShowingHint = true;
    }

    protected void applyHintStyle() {
        this.setForeground(this.getDisabledTextColor());
    }

    private void hideHint() {
        super.setText(null);
        this.restoreNormalStyle();
        this.isDirty = false;
        this.isShowingHint = false;
    }

    protected void restoreNormalStyle() {
        this.setForeground(this.originalForeground);
    }

    @Override
    public String getText() {
        return this.isShowingHint ? "" : super.getText();
    }

    @Override
    public void setText(String t) {
        if (t.isEmpty() && !this.hasFocus()) {
            this.showHint();
        } else {
            this.hideHint();
            super.setText(t);
            this.isDirty = true;
        }
    }
}

