/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.ISVNReporter;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.RemoteFileRevisionsCallback;
import org.apache.subversion.javahl.callback.RemoteLocationSegmentsCallback;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;

public interface ISVNRemote {
    public void dispose();

    public void cancelOperation() throws ClientException;

    public void reparent(String var1) throws ClientException;

    public String getSessionUrl() throws ClientException;

    public String getSessionRelativePath(String var1) throws ClientException;

    public String getReposRelativePath(String var1) throws ClientException;

    public String getReposUUID() throws ClientException;

    public String getReposRootUrl() throws ClientException;

    public long getLatestRevision() throws ClientException;

    public long getRevisionByDate(Date var1) throws ClientException;

    public long getRevisionByTimestamp(long var1) throws ClientException;

    public void changeRevisionProperty(long var1, String var3, byte[] var4, byte[] var5) throws ClientException;

    public Map<String, byte[]> getRevisionProperties(long var1) throws ClientException;

    public byte[] getRevisionProperty(long var1, String var3) throws ClientException;

    public ISVNEditor getCommitEditor(Map<String, byte[]> var1, CommitCallback var2, Set<Lock> var3, boolean var4, ISVNEditor.ProvideBaseCallback var5, ISVNEditor.ProvidePropsCallback var6, ISVNEditor.GetNodeKindCallback var7) throws ClientException;

    public ISVNEditor getCommitEditor(Map<String, byte[]> var1, CommitCallback var2, Set<Lock> var3, boolean var4) throws ClientException;

    public long getFile(long var1, String var3, OutputStream var4, Map<String, byte[]> var5) throws ClientException;

    public long getDirectory(long var1, String var3, int var4, Map<String, DirEntry> var5, Map<String, byte[]> var6) throws ClientException;

    public Map<String, Mergeinfo> getMergeinfo(Iterable<String> var1, long var2, Mergeinfo.Inheritance var4, boolean var5) throws ClientException;

    public ISVNReporter status(String var1, long var2, Depth var4, RemoteStatus var5) throws ClientException;

    public void getLog(Iterable<String> var1, long var2, long var4, int var6, boolean var7, boolean var8, boolean var9, Iterable<String> var10, LogMessageCallback var11) throws ClientException;

    public NodeKind checkPath(String var1, long var2) throws ClientException;

    public DirEntry stat(String var1, long var2) throws ClientException;

    public Map<Long, String> getLocations(String var1, long var2, Iterable<Long> var4) throws ClientException;

    public void getLocationSegments(String var1, long var2, long var4, long var6, RemoteLocationSegmentsCallback var8) throws ClientException;

    public List<LocationSegment> getLocationSegments(String var1, long var2, long var4, long var6) throws ClientException;

    public void getFileRevisions(String var1, long var2, long var4, boolean var6, RemoteFileRevisionsCallback var7) throws ClientException;

    public List<FileRevision> getFileRevisions(String var1, long var2, long var4, boolean var6) throws ClientException;

    public Map<String, Lock> getLocks(String var1, Depth var2) throws ClientException;

    public boolean hasCapability(Capability var1) throws ClientException;

    public static enum Capability {
        depth("depth"),
        mergeinfo("mergeinfo"),
        log_revprops("log-revprops"),
        partial_replay("partial-replay"),
        commit_revprops("commit-revprops"),
        atomic_revprops("atomic-revprops"),
        inherited_props("inherited-props"),
        ephemeral_txnprops("ephemeral-txnprops"),
        get_file_revs_reversed("get-file-revs-reversed");

        private String token;

        private Capability(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }

    public static final class FileRevision
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String path;
        private long revision;
        private boolean resultOfMerge;
        private Map<String, byte[]> revisionProperties;
        private Map<String, byte[]> propertiesDelta;
        private boolean textDelta;

        FileRevision(String path, long revision, boolean resultOfMerge, Map<String, byte[]> revisionProperties, Map<String, byte[]> propertiesDelta, boolean textDelta) {
            this.path = path;
            this.revision = revision;
            this.resultOfMerge = resultOfMerge;
            this.revisionProperties = revisionProperties;
            this.propertiesDelta = propertiesDelta;
            this.textDelta = textDelta;
        }

        public String getPath() {
            return this.path;
        }

        public long getRevision() {
            return this.revision;
        }

        public boolean isResultOfMerge() {
            return this.resultOfMerge;
        }

        public Map<String, byte[]> getRevisionProperties() {
            return this.revisionProperties;
        }

        public Map<String, byte[]> getPropertiesDelta() {
            return this.propertiesDelta;
        }

        public boolean hasTextDelta() {
            return this.textDelta;
        }
    }

    public static class LocationSegment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String path;
        private long startRevision;
        private long endRevision;

        LocationSegment(String path, long startRevision, long endRevision) {
            this.path = path;
            this.startRevision = startRevision;
            this.endRevision = endRevision;
        }

        public String getPath() {
            return this.path;
        }

        public long getStartRevision() {
            return this.startRevision;
        }

        public long getEndRevision() {
            return this.endRevision;
        }
    }
}

