/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.api.entity.generator;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.JavaPersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class EntitiesFromDBGenerator {
    private final List<String> tableNames;
    private final boolean generateNamedQueries;
    private final String packageName;
    private final SourceGroup location;
    private final DatabaseConnection connection;
    private final Project project;
    private final PersistenceUnit persistenceUnit;
    private final PersistenceGenerator generator;
    private boolean fullyQualifiedTableNames;
    private EntityRelation.CollectionType collectionType;
    private boolean regenTableAttrs;
    private EntityRelation.FetchType fetchType;
    private SchemaElement schemaElement;

    public EntitiesFromDBGenerator(List<String> tableNames, boolean generateNamedQueries, boolean fullyQualifiedTableNames, boolean regenTablesAttrs, EntityRelation.FetchType fetchType, EntityRelation.CollectionType collectionType, String packageName, SourceGroup location, DatabaseConnection connection, Project project, PersistenceUnit persistenceUnit) {
        this(tableNames, generateNamedQueries, fullyQualifiedTableNames, regenTablesAttrs, fetchType, collectionType, packageName, location, connection, project, persistenceUnit, new JavaPersistenceGenerator(persistenceUnit));
    }

    public EntitiesFromDBGenerator(List<String> tableNames, boolean generateNamedQueries, boolean fullyQualifiedTableNames, boolean regenTablesAttrs, EntityRelation.FetchType fetchType, EntityRelation.CollectionType collectionType, String packageName, SourceGroup location, DatabaseConnection connection, Project project, PersistenceUnit persistenceUnit, PersistenceGenerator persistenceGenerator) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"tableNames", tableNames);
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        Parameters.notNull((CharSequence)"location", (Object)location);
        Parameters.notNull((CharSequence)"connection", (Object)connection);
        this.tableNames = tableNames;
        this.generateNamedQueries = generateNamedQueries;
        this.fullyQualifiedTableNames = fullyQualifiedTableNames;
        this.regenTableAttrs = regenTablesAttrs;
        this.fetchType = fetchType;
        this.collectionType = collectionType;
        this.packageName = packageName;
        this.location = location;
        this.connection = connection;
        this.project = project;
        this.persistenceUnit = persistenceUnit;
        this.generator = persistenceGenerator;
    }

    public EntitiesFromDBGenerator(List<String> tableNames, boolean generateNamedQueries, String packageName, SourceGroup location, DatabaseConnection connection, Project project, PersistenceUnit persistenceUnit) {
        this(tableNames, generateNamedQueries, false, false, EntityRelation.FetchType.DEFAULT, EntityRelation.CollectionType.COLLECTION, packageName, location, connection, project, persistenceUnit);
    }

    public Set<FileObject> generate(ProgressContributor progressContributor) throws SQLException, IOException {
        RelatedCMPHelper helper = new RelatedCMPHelper(this.project, PersistenceLocation.getLocation((Project)this.project, (FileObject)this.location.getRootFolder()), this.generator);
        helper.setLocation(this.location);
        helper.setPackageName(this.packageName);
        try {
            TableClosure tableClosure = this.getTableClosure();
            SelectedTables selectedTables = new SelectedTables(this.generator, tableClosure, this.location, this.packageName);
            helper.setTableClosure(tableClosure);
            helper.setTableSource(this.getSchemaElement(), null);
            helper.setSelectedTables(selectedTables);
            helper.setGenerateFinderMethods(this.generateNamedQueries);
            helper.setFullyQualifiedTableNames(this.fullyQualifiedTableNames);
            helper.setRegenTablesAttrs(this.regenTableAttrs);
            helper.setFetchType(this.fetchType);
            helper.setCollectionType(this.collectionType);
            helper.buildBeans();
        }
        catch (DBException ex) {
            throw new IOException(ex);
        }
        this.generator.generateBeans(null, helper, null, progressContributor);
        Set<FileObject> result = this.generator.createdObjects();
        return result;
    }

    private TableClosure getTableClosure() throws SQLException, DBException {
        DBSchemaTableProvider tableProvider = new DBSchemaTableProvider(this.getSchemaElement(), this.generator, this.project);
        HashSet<Table> selectedTables = new HashSet<Table>();
        for (Table each : tableProvider.getTables()) {
            if (!this.tableNames.contains(each.getName())) continue;
            selectedTables.add(each);
        }
        TableClosure tableClosure = new TableClosure(tableProvider);
        tableClosure.addTables(selectedTables);
        return tableClosure;
    }

    private SchemaElement getSchemaElement() throws SQLException, DBException {
        if (this.schemaElement != null) {
            return this.schemaElement;
        }
        ConnectionProvider connectionProvider = this.getConnectionProvider();
        SchemaElementImpl impl = new SchemaElementImpl(connectionProvider);
        this.schemaElement = new SchemaElement((SchemaElement.Impl)impl);
        this.schemaElement.setName(DBIdentifier.create((String)"schema"));
        impl.initTables(connectionProvider, new LinkedList<String>(this.tableNames), new LinkedList(), true);
        return this.schemaElement;
    }

    private ConnectionProvider getConnectionProvider() throws SQLException {
        ConnectionProvider connectionProvider = new ConnectionProvider(this.connection.getJDBCConnection(), this.connection.getDriverClass());
        connectionProvider.setSchema(this.connection.getSchema());
        return connectionProvider;
    }
}

