/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsf.editor.actions.Bundle;
import org.netbeans.modules.web.jsf.editor.actions.FixDuplicateImportStmts;
import org.netbeans.modules.web.jsf.editor.actions.FixNamespacesPerformer;
import org.netbeans.modules.web.jsf.editor.actions.ImportData;
import org.netbeans.modules.web.jsf.editor.actions.NamespaceProcessor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class FixNamespacesAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final RequestProcessor RP = new RequestProcessor(FixNamespacesAction.class);
    private static final String PREFERENCES_NODE_KEY = FixNamespacesAction.class.getName();
    private static final String KEY_REMOVE_UNUSED_NS = "remove.unused.namespaces";
    private static final boolean REMOVE_UNUSED_NS_DEFAULT = true;
    static final String ACTION_NAME = "fix-imports";

    public FixNamespacesAction() {
        super(10);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            final AtomicBoolean cancel = new AtomicBoolean();
            final AtomicReference importData = new AtomicReference();
            final UserTask task = new UserTask(){

                public void run(ResultIterator ri) throws Exception {
                    Parser.Result parserResult = FixNamespacesAction.getHtmlParserResult(ri);
                    if (parserResult instanceof HtmlParserResult) {
                        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
                        if (cancel.get()) {
                            return;
                        }
                        ImportData data = FixNamespacesAction.this.computeNamespaces(htmlParserResult);
                        if (cancel.get()) {
                            return;
                        }
                        if (data.shouldShowNamespacesPanel) {
                            if (!cancel.get()) {
                                importData.set(data);
                            }
                        } else {
                            FixNamespacesAction.performFixNamespaces(htmlParserResult, data, data.getDefaultVariants(), FixNamespacesAction.isRemoveUnusedNs());
                        }
                    }
                }
            };
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ParserManager.parse(Collections.singleton(Source.create((Document)target.getDocument())), (UserTask)task);
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, (String)Bundle.FixNamespacesLabelLongName(), (AtomicBoolean)cancel, (boolean)false);
            if (importData.get() != null && !cancel.get()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FixNamespacesAction.showFixNamespacesDialog(target, (ImportData)importData.get());
                    }
                });
            }
        }
    }

    private static Parser.Result getHtmlParserResult(ResultIterator ri) throws ParseException {
        ResultIterator resultIterator = WebUtils.getResultIterator((ResultIterator)ri, (String)"text/html");
        if (resultIterator == null) {
            return null;
        }
        return resultIterator.getParserResult();
    }

    private static void performFixNamespaces(HtmlParserResult parserResult, ImportData importData, List<ImportData.VariantItem> selections, boolean removeUnused) {
        new FixNamespacesPerformer(parserResult, importData, selections, removeUnused).perform();
    }

    private ImportData computeNamespaces(HtmlParserResult parserResult) {
        NamespaceProcessor namespaceProcessor = new NamespaceProcessor(parserResult);
        return namespaceProcessor.computeImportData();
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(FixNamespacesAction.class).node(PREFERENCES_NODE_KEY);
    }

    private static boolean isRemoveUnusedNs() {
        return FixNamespacesAction.getPreferences().getBoolean(KEY_REMOVE_UNUSED_NS, true);
    }

    private static void setRemoveUnusedNs(boolean removeUnusedUses) {
        FixNamespacesAction.getPreferences().putBoolean(KEY_REMOVE_UNUSED_NS, removeUnusedUses);
    }

    private static void showFixNamespacesDialog(final JTextComponent target, final ImportData importData) {
        final FixDuplicateImportStmts panel = new FixDuplicateImportStmts();
        panel.initPanel(importData, FixNamespacesAction.isRemoveUnusedNs());
        final JButton ok = new JButton(Bundle.LBL_Ok());
        final JButton cancel = new JButton(Bundle.LBL_Cancel());
        final AtomicBoolean stop = new AtomicBoolean();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.FixNamespacesLabelLongName(), true, new Object[]{ok, cancel}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, null, true);
        final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok.setEnabled(false);
                final List<ImportData.VariantItem> selections = panel.getSelections();
                final boolean removeUnusedNamespaces = panel.getRemoveUnusedNamespaces();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ParserManager.parse(Collections.singleton(Source.create((Document)target.getDocument())), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    Parser.Result parserResult = FixNamespacesAction.getHtmlParserResult(resultIterator);
                                    if (parserResult instanceof HtmlParserResult) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                cancel.setEnabled(false);
                                                ((JDialog)d).setDefaultCloseOperation(0);
                                            }
                                        });
                                        if (stop.get()) {
                                            return;
                                        }
                                        FixNamespacesAction.performFixNamespaces((HtmlParserResult)parserResult, importData, selections, removeUnusedNamespaces);
                                    }
                                }
                            });
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        FixNamespacesAction.setRemoveUnusedNs(removeUnusedNamespaces);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                d.setVisible(false);
                            }
                        });
                    }
                });
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stop.set(true);
                d.setVisible(false);
            }
        });
        d.setVisible(true);
        d.dispose();
    }
}

