/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.AbstractOptionPanelManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.JSFTargetPanelProvider;
import org.openide.util.NbBundle;

class JSFUIManager
extends AbstractOptionPanelManager {
    private JRadioButton myFaceletsSyntaxButton;

    JSFUIManager() {
    }

    @Override
    public void initComponents(JPanel mainPanel, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        super.initComponents(mainPanel, panel, uiPanel);
        uiPanel.setNameLabel(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"LBL_JspName"));
        this.getJspSyntaxButton().setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"OPT_JspSyntax"));
        this.getJspSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"DESC_JSP"));
        this.myFaceletsSyntaxButton.setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"OPT_Facelets"));
        this.myFaceletsSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"DESC_FACELETS"));
        this.getSegmentBox().setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"OPT_JspSegment"));
        this.getSegmentBox().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"A11Y_DESC_JSP_segment"));
        this.getDescription().setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"DESC_FACELETS"));
    }

    public String getAccessibleDescription() {
        return "jsf";
    }

    public String getErrorMessage(TargetChooserPanel<FileType> panel) {
        if (this.isSegment() && !panel.getComponent().getNormalizedFolder().startsWith("WEB-INF/jspf")) {
            return NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"NOTE_segment");
        }
        return null;
    }

    public boolean isPanelValid() {
        return true;
    }

    protected boolean isFacelets() {
        if (this.myFaceletsSyntaxButton == null) {
            return false;
        }
        return this.myFaceletsSyntaxButton.isSelected();
    }

    protected boolean isSegment() {
        if (this.getSegmentBox() == null) {
            return false;
        }
        return this.getSegmentBox().isSelected() && this.getSegmentBox().isEnabled();
    }

    @Override
    protected void checkBoxChanged(ItemEvent evt, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        if (this.isFacelets()) {
            this.getSegmentBox().setEnabled(false);
            this.getDescription().setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"DESC_FACELETS"));
            this.setNewFileExtension(uiPanel, "xhtml");
        } else {
            this.getSegmentBox().setEnabled(true);
            if (this.isSegment()) {
                this.getDescription().setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"DESC_segment"));
                this.setNewFileExtension(uiPanel, "jspf");
            } else {
                this.getDescription().setText(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"DESC_JSP"));
                this.setNewFileExtension(uiPanel, "jsp");
            }
        }
        panel.fireChange();
    }

    private void setNewFileExtension(TargetChooserPanelGUI<FileType> uiPanel, String extension) {
        String createdFile = uiPanel.getFile();
        int dotOffset = createdFile.lastIndexOf(".");
        if (dotOffset > 0) {
            uiPanel.setFile(createdFile.substring(0, dotOffset + 1) + extension);
        } else {
            uiPanel.setFile(createdFile + "." + extension);
        }
    }

    @Override
    protected int initAdditionalSyntaxButton(int grid, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        return grid;
    }

    @Override
    protected int initSyntaxButton(int gridy, final TargetChooserPanel<FileType> panel, final TargetChooserPanelGUI<FileType> uiPanel) {
        this.myFaceletsSyntaxButton = new JRadioButton();
        this.myFaceletsSyntaxButton.setSelected(true);
        this.getSegmentBox().setEnabled(false);
        this.myFaceletsSyntaxButton.setMnemonic(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"A11Y_Facelets_mnem").charAt(0));
        this.getButtonGroup().add(this.myFaceletsSyntaxButton);
        this.myFaceletsSyntaxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFUIManager.this.checkBoxChanged(evt, (TargetChooserPanel<FileType>)panel, (TargetChooserPanelGUI<FileType>)uiPanel);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.anchor = 17;
        this.getOptionPanel().add((Component)this.myFaceletsSyntaxButton, gridBagConstraints);
        this.getJspSyntaxButton().setMnemonic(NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"A11Y_JspStandard_mnem").charAt(0));
        return gridy;
    }
}

