/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.wizards.AnnotationGenerator;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.ListenerGenerator;
import org.netbeans.modules.web.wizards.ListenerPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ListenerIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private static final Logger LOG = Logger.getLogger(ListenerIterator.class.getName());
    private ListenerPanel panel;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private static final long serialVersionUID = -7586964579556513549L;

    protected WizardDescriptor.Panel[] createPanels(TemplateWizard wizard) {
        WizardDescriptor.Panel packageChooserPanel;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups(project);
        this.panel = new ListenerPanel(wizard);
        if (sourceGroups.length == 0) {
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            sourceGroups = sources.getSourceGroups("generic");
            packageChooserPanel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.panel);
        } else {
            packageChooserPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.panel);
        }
        return new WizardDescriptor.Panel[]{packageChooserPanel};
    }

    public Set<DataObject> instantiate() throws IOException {
        FileObject folder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        DataFolder targetFolder = DataFolder.findFolder((FileObject)folder);
        ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        String listenerName = this.wiz.getTargetName();
        DataObject result = null;
        if (classPath != null) {
            DataObject template;
            HashMap<String, String> templateParameters = new HashMap<String, String>();
            if (!this.panel.createElementInDD() && Utilities.isJavaEE6Plus(this.wiz)) {
                templateParameters.put("classAnnotation", AnnotationGenerator.webListener());
            }
            if ((result = (template = this.wiz.getTemplate()).createFromTemplate(targetFolder, listenerName, templateParameters)) != null && this.panel.createElementInDD()) {
                WebModule wm;
                String className = classPath.getResourceName(result.getPrimaryFile(), '.', false);
                FileObject webAppFo = DeployData.getWebAppFor(folder);
                if (webAppFo == null && (wm = WebModule.getWebModule((FileObject)folder)) != null) {
                    FileObject webInfFolder = wm.getWebInf();
                    if (webInfFolder == null) {
                        webInfFolder = FileUtil.createFolder((FileObject)folder, (String)"WEB-INF");
                    }
                    webAppFo = DDHelper.createWebXml((Profile)wm.getJ2eeProfile(), (FileObject)webInfFolder);
                }
                WebApp webApp = null;
                if (webAppFo != null) {
                    webApp = DDProvider.getDefault().getDDRoot(webAppFo);
                }
                if (webApp != null) {
                    Listener[] oldListeners = webApp.getListener();
                    boolean found = false;
                    for (int i = 0; i < oldListeners.length; ++i) {
                        if (!className.equals(oldListeners[i].getListenerClass())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        try {
                            Listener listener = (Listener)webApp.createBean("Listener");
                            listener.setListenerClass(className);
                            StringBuffer desc = new StringBuffer();
                            int i = 0;
                            if (this.panel.isContextListener()) {
                                desc.append("ServletContextListener");
                                ++i;
                            }
                            if (this.panel.isContextAttrListener()) {
                                if (i > 0) {
                                    desc.append(", ");
                                }
                                desc.append("ServletContextAttributeListener");
                                ++i;
                            }
                            if (this.panel.isSessionListener()) {
                                if (i > 0) {
                                    desc.append(", ");
                                }
                                desc.append("HttpSessionListener");
                                ++i;
                            }
                            if (this.panel.isSessionAttrListener()) {
                                if (i > 0) {
                                    desc.append(", ");
                                }
                                desc.append("HttpSessionAttributeListener");
                            }
                            if (this.panel.isRequestListener()) {
                                if (i > 0) {
                                    desc.append(", ");
                                }
                                desc.append("RequestListener");
                                ++i;
                            }
                            if (this.panel.isRequestAttrListener()) {
                                if (i > 0) {
                                    desc.append(", ");
                                }
                                desc.append("RequestAttributeListener");
                            }
                            listener.setDescription(desc.toString());
                            webApp.addListener(listener);
                            webApp.write(webAppFo);
                        }
                        catch (ClassNotFoundException ex) {
                            LOG.log(Level.FINE, "error", ex);
                        }
                    }
                }
            }
            if (result != null) {
                JavaSource clazz;
                Project project = Templates.getProject((WizardDescriptor)this.wiz);
                ContainerClassPathModifier modifier = (ContainerClassPathModifier)project.getLookup().lookup(ContainerClassPathModifier.class);
                if (modifier != null) {
                    modifier.extendClasspath(result.getPrimaryFile(), new String[]{"servlet-api"});
                }
                if ((clazz = JavaSource.forFileObject((FileObject)result.getPrimaryFile())) != null) {
                    ListenerGenerator gen = new ListenerGenerator(this.panel.isContextListener(), this.panel.isContextAttrListener(), this.panel.isSessionListener(), this.panel.isSessionAttrListener(), this.panel.isRequestListener(), this.panel.isRequestAttrListener());
                    try {
                        gen.generate(clazz);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        } else {
            String mes = MessageFormat.format(NbBundle.getMessage(ListenerIterator.class, (String)"TXT_wrongFolderForClass"), "Servlet Listener");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return null;
        }
        return Collections.singleton(result);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = (TemplateWizard)wiz;
        this.index = 0;
        this.panels = this.createPanels(this.wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(ListenerIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

