/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject.idenative;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.newproject.TemplateUtils;
import org.netbeans.modules.maven.newproject.idenative.Bundle;
import org.netbeans.modules.maven.spi.newproject.CreateProjectBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;

public class IDENativeTemplateHandler
extends CreateFromTemplateHandler {
    public static final String PARAM_CONTENT_TEMPLATE = "projectContentsTemplate";

    protected boolean accept(CreateDescriptor desc) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
        boolean handleCreated;
        String packaging = (String)desc.getValue("packaging");
        File projDir = (File)desc.getValue("projdir");
        if (projDir == null) {
            projDir = FileUtil.toFile((FileObject)desc.getTarget());
        }
        if (projDir == null) {
            throw new IOException("projdir not specified");
        }
        ProgressHandle handle = (ProgressHandle)desc.getLookup().lookup(ProgressHandle.class);
        boolean bl = handleCreated = handle == null;
        if (handle == null) {
            handle = ProgressHandle.createHandle((String)Bundle.TITLE_CreatingNewProject());
        }
        File projFile = FileUtil.normalizeFile((File)projDir);
        ProjectInfo pi = TemplateUtils.createProjectInfo(desc.getName(), desc.getParameters());
        File toCreate = new File(projFile, desc.getName());
        CreateProjectBuilder builder = this.customizeBuilder(new CreateProjectBuilder(toCreate, pi.groupId, pi.artifactId, pi.version).setProgressHandle(handle).setPackaging(packaging).setPackageName(pi.packageName), pi);
        if (handleCreated) {
            handle.start();
        }
        try {
            builder.create();
            ProjectManager.getDefault().clearNonProjectCache();
            FileObject fo = FileUtil.toFileObject((File)toCreate);
            Properties p = new Properties();
            List<FileObject> toOpen = this.createProjectContents(fo, desc, pi, p);
            List<FileObject> list = TemplateUtils.afterTemplateCreation(p, desc, toOpen, fo);
            return list;
        }
        finally {
            if (handleCreated) {
                handle.finish();
            }
        }
    }

    String deriveClassName(String artifactName) {
        String[] parts = artifactName.split("\\W+");
        StringBuilder sb = new StringBuilder();
        for (String s : parts) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            sb.append(s.substring(1));
        }
        return sb.toString();
    }

    protected List<FileObject> createProjectContents(FileObject target, CreateDescriptor cd, ProjectInfo pi, Properties p) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(cd.getParameters());
        params.remove("name");
        params.remove("nameAndExt");
        params.put("template.mergeFolders", Boolean.TRUE);
        params.put("projecName", cd.getName());
        params.put("packagePath", pi.packageName == null ? "" : pi.packageName.replace('.', '/'));
        String packaging = (String)cd.getValue("packaging");
        if ((packaging == null || "jar".equals(packaging)) && !params.containsKey("mainClassName")) {
            String derived = this.deriveClassName(pi.artifactId);
            String mainName = BaseUtilities.isJavaIdentifier((String)derived) ? derived : "App";
            params.put("mainClassName", mainName);
        }
        String contentPath = null;
        FileObject projectContents = null;
        Object o = cd.getTemplate().getAttribute(PARAM_CONTENT_TEMPLATE);
        if (o == null) {
            FileObject tf = cd.getTemplate();
            String rel = FileUtil.getRelativePath((FileObject)FileUtil.getConfigFile((String)"Templates"), (FileObject)tf);
            if (rel == null || rel.startsWith("..")) {
                contentPath = null;
            } else {
                projectContents = FileUtil.getConfigFile((String)("Maven2Templates/ProjectContents/" + rel));
            }
        } else {
            contentPath = o.toString();
        }
        if (contentPath != null) {
            projectContents = FileUtil.getConfigFile((String)contentPath);
        } else if (cd.getTemplate().isFolder()) {
            projectContents = cd.getTemplate();
        }
        if (projectContents == null) {
            return null;
        }
        if (!projectContents.isFolder() || !Boolean.TRUE.equals(projectContents.getAttribute("template"))) {
            return null;
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (FileObject c : projectContents.getChildren()) {
            result.addAll(new FileBuilder(c, target).defaultMode(FileBuilder.Mode.COPY).withParameters(params).build());
        }
        for (Map.Entry entry : params.entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            p.put(k, v);
        }
        return result;
    }

    protected CreateProjectBuilder customizeBuilder(CreateProjectBuilder builder, ProjectInfo pi) {
        return builder;
    }
}

