/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.requests.ListBuildRunsRequest;
import com.oracle.bmc.devops.responses.ListBuildRunsResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.devops.BuildRunFolderItem;
import org.netbeans.modules.cloud.oracle.devops.BuildRunItem;
import org.netbeans.modules.cloud.oracle.devops.Bundle;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class BuildRunNode
extends OCINode {
    private static final String GREEN = "org/netbeans/modules/cloud/oracle/resources/green_dot.svg";
    private static final String RED = "org/netbeans/modules/cloud/oracle/resources/red_dot.svg";
    private static final String YELLOW = "org/netbeans/modules/cloud/oracle/resources/yellow_dot.svg";

    public BuildRunNode(BuildRunItem item) {
        super((OCIItem)item, Children.LEAF);
        switch (item.getLifecycleState().toLowerCase()) {
            case "succeeded": {
                this.setIconBaseWithExtension(GREEN);
                break;
            }
            case "failed": {
                this.setIconBaseWithExtension(RED);
                break;
            }
            default: {
                this.setIconBaseWithExtension(YELLOW);
            }
        }
    }

    public static NodeProvider<BuildRunItem> createNode() {
        return BuildRunNode::new;
    }

    public static ChildrenProvider<DevopsProjectItem, BuildRunFolderItem> listBuildRuns() {
        return project -> Collections.singletonList(new BuildRunFolderItem(OCID.of(project.getKey().getValue(), "BuildRunFolder"), Bundle.BuildRuns()));
    }

    public static ChildrenProvider<BuildRunFolderItem, BuildRunItem> expandBuildRuns() {
        return project -> {
            try (DevopsClient client = new DevopsClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
                ListBuildRunsRequest request = ListBuildRunsRequest.builder().projectId(project.getKey().getValue()).sortBy(ListBuildRunsRequest.SortBy.TimeCreated).limit(Integer.valueOf(6)).build();
                ListBuildRunsResponse response = client.listBuildRuns(request);
                List projects = response.getBuildRunSummaryCollection().getItems();
                List list = projects.stream().map(p -> new BuildRunItem(OCID.of(p.getId(), "BuildRun"), p.getDisplayName(), p.getLifecycleState().getValue())).collect(Collectors.toList());
                return list;
            }
        };
    }

    public static NodeProvider<BuildRunFolderItem> createFolderNode() {
        return BuildRunFolderNode::new;
    }

    public static class BuildRunFolderNode
    extends OCINode {
        private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/build_run_folder.svg";

        public BuildRunFolderNode(BuildRunFolderItem folder) {
            super(folder);
            this.setIconBaseWithExtension(ICON);
        }

        @Override
        public void refresh() {
            ((OCINode)this.getParentNode()).refresh();
        }
    }
}

