/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.options.InlineHintsOptionsPanelController;
import org.netbeans.modules.java.editor.options.InlineHintsSettings;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class InlineHintsPanel
extends JPanel {
    public static final String JAVA_INLINE_HINT_PARAMETER_NAME = "javaInlineHintParameterName";
    public static final String JAVA_INLINE_HINT_CHAINED_TYPES = "javaInlineHintChainedTypes";
    public static final String JAVA_INLINE_HINT_VAR_TYPE = "javaInlineHintVarType";
    private static final Map<String, Boolean> DEFAULT_VALUES;
    private List<JCheckBox> boxes;
    private InlineHintsOptionsPanelController controller;
    private boolean changed = false;
    private Box.Filler filler1;
    private JCheckBox javaInlineHintChainedTypesCB;
    private JCheckBox javaInlineHintParameterNameCB;
    private JCheckBox javaInlineHintVarTypeCB;

    public InlineHintsPanel(InlineHintsOptionsPanelController controller) {
        this.initComponents();
        this.fillBoxes();
        this.addListeners();
        this.load(controller);
    }

    public void load(InlineHintsOptionsPanelController controller) {
        this.controller = controller;
        Preferences node = InlineHintsSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            box.setSelected(node.getBoolean(box.getActionCommand(), DEFAULT_VALUES.get(box.getActionCommand())));
        }
        this.changed = false;
    }

    public void store() {
        Preferences node = InlineHintsSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), DEFAULT_VALUES.get(box.getActionCommand())))) continue;
            node.putBoolean(box.getActionCommand(), value);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changed = false;
        EditorRegistry.componentList().stream().map(jtc -> jtc.getDocument()).filter(doc -> doc != null).map(doc -> NbEditorUtilities.getFileObject((Document)doc)).filter(fo -> fo != null).forEach(fo -> IndexingManager.getDefault().refreshAllIndices(new FileObject[]{fo}));
    }

    public boolean changed() {
        return this.changed;
    }

    private void initComponents() {
        this.javaInlineHintParameterNameCB = new JCheckBox();
        this.javaInlineHintChainedTypesCB = new JCheckBox();
        this.javaInlineHintVarTypeCB = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintParameterNameCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintParameterNameCB.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.javaInlineHintParameterNameCB, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintChainedTypesCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintChainedTypesCB.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.javaInlineHintChainedTypesCB, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintVarTypeCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintVarTypeCB.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.javaInlineHintVarTypeCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void fillBoxes() {
        this.boxes = new ArrayList<JCheckBox>();
        this.boxes.add(this.javaInlineHintParameterNameCB);
        this.boxes.add(this.javaInlineHintChainedTypesCB);
        this.boxes.add(this.javaInlineHintVarTypeCB);
        this.javaInlineHintParameterNameCB.setActionCommand(JAVA_INLINE_HINT_PARAMETER_NAME);
        this.javaInlineHintChainedTypesCB.setActionCommand(JAVA_INLINE_HINT_CHAINED_TYPES);
        this.javaInlineHintVarTypeCB.setActionCommand(JAVA_INLINE_HINT_VAR_TYPE);
    }

    private void addListeners() {
        CheckChangeListener cl = new CheckChangeListener();
        for (JCheckBox box : this.boxes) {
            box.addChangeListener(cl);
        }
    }

    private void fireChanged() {
        Preferences node = InlineHintsSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            if (node.getBoolean(box.getActionCommand(), DEFAULT_VALUES.get(box.getActionCommand())) == box.isSelected()) continue;
            this.changed = true;
            return;
        }
        this.changed = false;
    }

    static {
        HashMap<String, Boolean> defaultValuesBuilder = new HashMap<String, Boolean>();
        defaultValuesBuilder.put(JAVA_INLINE_HINT_PARAMETER_NAME, true);
        defaultValuesBuilder.put(JAVA_INLINE_HINT_CHAINED_TYPES, false);
        defaultValuesBuilder.put(JAVA_INLINE_HINT_VAR_TYPE, false);
        DEFAULT_VALUES = Collections.unmodifiableMap(defaultValuesBuilder);
    }

    private class CheckChangeListener
    implements ChangeListener {
        private CheckChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            InlineHintsPanel.this.fireChanged();
        }
    }
}

