/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.openide.filesystems.FileObject;

public abstract class RefactoringElement {
    protected final FileObject fileObject;
    protected final ASTNode node;
    protected Set<Modifier> modifiers;

    protected RefactoringElement(FileObject fileObject, ASTNode node) {
        this.fileObject = fileObject;
        this.node = node;
    }

    public abstract String getName();

    public abstract ElementKind getKind();

    public abstract String getShowcase();

    public final String getOwnerName() {
        return ElementUtils.getDeclaringClassName((ASTNode)this.node);
    }

    public final String getOwnerNameWithoutPackage() {
        return ElementUtils.getDeclaringClassNameWithoutPackage((ASTNode)this.node);
    }

    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            int flags = -1;
            if (this.node instanceof FieldNode) {
                flags = ((FieldNode)this.node).getModifiers();
            } else if (this.node instanceof MethodNode) {
                flags = ((MethodNode)this.node).getModifiers();
            } else if (this.node instanceof ClassNode) {
                flags = ((ClassNode)this.node).getModifiers();
            }
            if (flags != -1) {
                EnumSet<Modifier> result = EnumSet.noneOf(Modifier.class);
                if ((flags & 1) != 0) {
                    result.add(Modifier.PUBLIC);
                }
                if ((flags & 4) != 0) {
                    result.add(Modifier.PROTECTED);
                }
                if ((flags & 2) != 0) {
                    result.add(Modifier.PRIVATE);
                }
                if ((flags & 8) != 0) {
                    result.add(Modifier.STATIC);
                }
                this.modifiers = result;
            } else {
                this.modifiers = Collections.emptySet();
            }
        }
        return this.modifiers;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public ASTNode getNode() {
        return this.node;
    }
}

