/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreeScanner;
import org.netbeans.modules.java.debug.CommentsNode;
import org.netbeans.modules.java.debug.DocTreeNode;
import org.netbeans.modules.java.debug.ElementNode;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class TreeNode
extends AbstractNode
implements OffsetProvider {
    private TreePath tree;
    private CompilationInfo info;
    private boolean synthetic;
    private static String[] c = new String[]{"&", "<", ">", "\""};
    private static String[] tags = new String[]{"&amp;", "&lt;", "&gt;", "&quot;"};

    public static Node getTree(CompilationInfo info, TreePath tree, AtomicBoolean cancel) {
        ArrayList<Node> result = new ArrayList<Node>();
        new FindChildrenTreeVisitor(info, cancel).scan(tree, result);
        return (Node)result.get(0);
    }

    @CheckForNull
    public static Node findNode(@NonNull Node parent, @NonNull TreePath tree) {
        LinkedList<Tree> trees = new LinkedList<Tree>();
        while (tree != null) {
            trees.add(tree.getLeaf());
            tree = tree.getParentPath();
        }
        if (trees.isEmpty()) {
            return null;
        }
        Collections.reverse(trees);
        Iterator<Tree> it = trees.iterator();
        it.next();
        return TreeNode.findNode(parent, it);
    }

    @NonNull
    private static Node findNode(@NonNull Node parent, @NonNull Iterator<Tree> trees) {
        if (!trees.hasNext()) {
            return parent;
        }
        Tree next = trees.next();
        for (Node child : parent.getChildren().getNodes(true)) {
            if (child.getLookup().lookup(Tree.class) != next) continue;
            return TreeNode.findNode(child, trees);
        }
        return parent;
    }

    public TreeNode(CompilationInfo info, TreePath tree, List<Node> nodes) {
        super((Children)(nodes.isEmpty() ? Children.LEAF : new NodeChilren(nodes)), Lookups.singleton((Object)tree.getLeaf()));
        this.tree = tree;
        this.info = info;
        this.synthetic = info.getTreeUtilities().isSynthetic(tree);
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(tree.getCompilationUnit(), tree.getLeaf());
        int end = (int)info.getTrees().getSourcePositions().getEndPosition(tree.getCompilationUnit(), tree.getLeaf());
        String text = start >= 0 && end >= 0 && end > start ? info.getText().substring(start, end) : tree.getLeaf().toString();
        this.setDisplayName(tree.getLeaf().getKind().toString() + ":" + text);
        this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/tree.png");
    }

    public String getHtmlDisplayName() {
        if (this.synthetic) {
            return "<html><font color='#808080'>" + this.translate(this.getDisplayName());
        }
        return null;
    }

    private String translate(String input) {
        for (int cntr = 0; cntr < c.length; ++cntr) {
            input = input.replace(c[cntr], tags[cntr]);
        }
        return input;
    }

    @Override
    public int getStart() {
        return (int)this.info.getTrees().getSourcePositions().getStartPosition(this.tree.getCompilationUnit(), this.tree.getLeaf());
    }

    @Override
    public int getEnd() {
        return (int)this.info.getTrees().getSourcePositions().getEndPosition(this.tree.getCompilationUnit(), this.tree.getLeaf());
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }

    static Node nodeForElement(CompilationInfo info, Element el) {
        if (el != null) {
            return new ElementNode(info, el, Collections.emptyList());
        }
        return new NotFoundElementNode(NbBundle.getMessage(TreeNode.class, (String)"Cannot_Resolve_Element"));
    }

    private static class NotFoundTypeNode
    extends AbstractNode {
        public NotFoundTypeNode(String name) {
            super(Children.LEAF);
            this.setName(name);
            this.setDisplayName(name);
            this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/type.png");
        }
    }

    private static class TypeNode
    extends AbstractNode {
        public TypeNode(TypeMirror type) {
            super(Children.LEAF);
            this.setDisplayName(type.getKind().toString() + ":" + type.toString());
            this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/type.png");
        }
    }

    private static class NotFoundElementNode
    extends AbstractNode {
        public NotFoundElementNode(String name) {
            super(Children.LEAF);
            this.setName(name);
            this.setDisplayName(name);
            this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/element.png");
        }
    }

    private static class NotFoundJavadocNode
    extends AbstractNode {
        public NotFoundJavadocNode(String name) {
            super(Children.LEAF);
            this.setName(name);
            this.setDisplayName(name);
        }
    }

    private static class FindChildrenTreeVisitor
    extends CancellableTreeScanner<Void, List<Node>> {
        private final CompilationInfo info;
        private TreePath currentPath;

        public FindChildrenTreeVisitor(CompilationInfo info, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
        }

        public Void scan(TreePath path, List<Node> d) {
            this.currentPath = path.getParentPath();
            this.scan(path.getLeaf(), d);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(Tree tree, List<Node> d) {
            if (tree != null) {
                TreePath oldPath = this.currentPath;
                try {
                    ArrayList<Node> below = new ArrayList<Node>();
                    this.currentPath = new TreePath(this.currentPath, tree);
                    this.addCorrespondingElement(this.currentPath, below);
                    this.addCorrespondingType(this.currentPath, below);
                    this.addCorrespondingComments(this.currentPath, below);
                    this.addCorrespondingJavadoc(this.currentPath, below);
                    super.scan(tree, below);
                    d.add((Node)new TreeNode(this.info, this.currentPath, below));
                }
                finally {
                    this.currentPath = oldPath;
                }
            }
            return null;
        }

        private void addCorrespondingJavadoc(TreePath currentPath, List<Node> below) {
            DocCommentTree docCommentTree = ((DocTrees)this.info.getTrees()).getDocCommentTree(currentPath);
            if (docCommentTree != null) {
                below.add((Node)new DocTreeNode(this.info, currentPath, docCommentTree, docCommentTree));
            } else {
                below.add((Node)new NotFoundJavadocNode("<javadoc-not-found>"));
            }
        }

        private void addCorrespondingElement(TreePath currentPath, List<Node> below) {
            Element el = this.info.getTrees().getElement(currentPath);
            below.add(TreeNode.nodeForElement(this.info, el));
        }

        private void addCorrespondingType(TreePath currentPath, List<Node> below) {
            TypeMirror tm = this.info.getTrees().getTypeMirror(currentPath);
            if (tm != null) {
                below.add((Node)new TypeNode(tm));
            } else {
                below.add((Node)new NotFoundTypeNode(NbBundle.getMessage(TreeNode.class, (String)"Cannot_Resolve_Type")));
            }
        }

        private void addCorrespondingComments(TreePath currentPath, List<Node> below) {
            below.add((Node)new CommentsNode(NbBundle.getMessage(TreeNode.class, (String)"NM_Preceding_Comments"), this.info.getTreeUtilities().getComments(currentPath.getLeaf(), true)));
            below.add((Node)new CommentsNode(NbBundle.getMessage(TreeNode.class, (String)"NM_Trailing_Comments"), this.info.getTreeUtilities().getComments(currentPath.getLeaf(), false)));
        }
    }

    static final class NodeChilren
    extends Children.Array {
        public NodeChilren(List<Node> nodes) {
            super(nodes);
        }
    }
}

