/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.NbMoveRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.NbSafeDeleteRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.NbWhereUsedRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.RetoucheUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class NbRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Project project;
        Lookup look = refactoring.getRefactoringSource();
        FileObject file = (FileObject)look.lookup(FileObject.class);
        NonRecursiveFolder folder = (NonRecursiveFolder)look.lookup(NonRecursiveFolder.class);
        TreePathHandle handle = (TreePathHandle)look.lookup(TreePathHandle.class);
        FileObject prjFile = file;
        if (prjFile == null && folder != null) {
            prjFile = folder.getFolder();
        }
        if (prjFile == null && handle != null) {
            prjFile = handle.getFileObject();
        }
        if (prjFile != null && ((project = FileOwnerQuery.getOwner((FileObject)prjFile)) == null || project.getLookup().lookup(NbModuleProvider.class) == null)) {
            return null;
        }
        if (refactoring instanceof WhereUsedQuery && handle != null) {
            return new NbWhereUsedRefactoringPlugin(refactoring);
        }
        if (refactoring instanceof RenameRefactoring) {
            if (handle != null || file != null && RetoucheUtils.isJavaFile(file)) {
                return new NbRenameRefactoringPlugin((AbstractRefactoring)((RenameRefactoring)refactoring));
            }
            if (file != null && RetoucheUtils.isOnSourceClasspath(file) && file.isFolder()) {
                return new NbMoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (folder != null && RetoucheUtils.isOnSourceClasspath(folder.getFolder())) {
                return new NbMoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (folder != null && !RetoucheUtils.isOnSourceClasspath(folder.getFolder())) {
                return new NbMoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
        }
        if (refactoring instanceof MoveRefactoring) {
            // empty if block
        }
        if (refactoring instanceof SafeDeleteRefactoring && handle != null) {
            return new NbSafeDeleteRefactoringPlugin(refactoring);
        }
        return null;
    }
}

