/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.CoreAllocator;
import com.oracle.truffle.object.CoreLocation;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.DefaultLayout;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.ShapeImpl;
import java.util.Objects;

final class DefaultStrategy
extends LayoutStrategy {
    static final LayoutStrategy SINGLETON = new DefaultStrategy();
    private static final LocationFactory DEFAULT_LOCATION_FACTORY = DefaultStrategy.createDefaultLocationFactory(0L);

    private DefaultStrategy() {
    }

    @Override
    public boolean updateShape(DynamicObject object) {
        assert (object.getShape().isValid());
        return false;
    }

    @Override
    public ShapeImpl ensureValid(ShapeImpl newShape) {
        assert (newShape.isValid());
        return newShape;
    }

    private static boolean assertLocationInRange(ShapeImpl shape, Location location) {
        DefaultLayout layout = (DefaultLayout)shape.getLayout();
        assert (shape.getPrimitiveFieldSize() + ((LocationImpl)location).primitiveFieldCount() <= layout.getPrimitiveFieldCount());
        assert (shape.getObjectFieldSize() + ((LocationImpl)location).objectFieldCount() <= layout.getObjectFieldCount());
        return true;
    }

    @Override
    public ShapeImpl ensureSpace(ShapeImpl shape, Location location) {
        Objects.requireNonNull(location);
        assert (DefaultStrategy.assertLocationInRange(shape, location));
        return shape;
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(ShapeImpl shape) {
        return new CoreAllocator(shape);
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(LayoutImpl layout) {
        return new CoreAllocator(layout);
    }

    @Override
    protected LocationFactory getDefaultLocationFactory(long putFlags) {
        if (putFlags == 0L) {
            return DEFAULT_LOCATION_FACTORY;
        }
        return DefaultStrategy.createDefaultLocationFactory(putFlags);
    }

    private static LocationFactory createDefaultLocationFactory(final long putFlags) {
        return new LocationFactory(){

            @Override
            public Location createLocation(Shape shape, Object value) {
                return ((CoreAllocator)((ShapeImpl)shape).allocator()).locationForValue(value, true, value != null, putFlags);
            }
        };
    }

    @Override
    protected int getLocationOrdinal(Location location) {
        return CoreLocations.getLocationOrdinal((CoreLocation)location);
    }
}

