/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.scope;

import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.spi.ui.ScopeProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class OpenProjectsScopeProvider
extends ScopeProvider {
    private Scope scope;

    public boolean initialize(Lookup context, AtomicBoolean cancel) {
        Project[] projects;
        Future openProjects = OpenProjects.getDefault().openProjects();
        try {
            projects = (Project[])openProjects.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            return false;
        }
        if (projects == null || projects.length == 0) {
            return false;
        }
        HashSet<FileObject> srcRoots = new HashSet<FileObject>();
        for (Project project : projects) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)project);
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)pi.getProject()).getSourceGroups("java");
            for (int i = 0; i < sourceGroups.length; ++i) {
                srcRoots.add(sourceGroups[i].getRootFolder());
            }
        }
        if (srcRoots.isEmpty()) {
            return false;
        }
        this.scope = Scope.create(srcRoots, null, null);
        return true;
    }

    public Scope getScope() {
        return this.scope;
    }
}

