/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.util.Arrays;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GradleVersion;

class NetBeansRunSinglePlugin
implements Plugin<Project> {
    private static final GradleVersion GRADLE_VERSION = GradleVersion.current().getBaseVersion();
    private static final Logger LOG = Logging.getLogger(NetBeansRunSinglePlugin.class);
    private static final String RUN_SINGLE_TASK = "runSingle";
    private static final String RUN_SINGLE_MAIN = "runClassName";
    private static final String RUN_SINGLE_ARGS = "runArgs";
    private static final String RUN_SINGLE_JVM_ARGS = "runJvmArgs";
    private static final String RUN_SINGLE_CWD = "runWorkingDir";

    NetBeansRunSinglePlugin() {
    }

    public void apply(Project project) {
        project.afterEvaluate(p -> {
            if (p.getPlugins().hasPlugin("java") && project.getTasks().findByPath(RUN_SINGLE_TASK) == null && project.hasProperty(RUN_SINGLE_MAIN)) {
                this.addTask((Project)p);
            }
            p.getTasks().withType(JavaExec.class).configureEach(je -> {
                if (p.hasProperty(RUN_SINGLE_JVM_ARGS)) {
                    je.getJvmArgumentProviders().add(new CommandLineArgumentProvider((Project)p){
                        final /* synthetic */ Project val$p;
                        {
                            this.val$p = project;
                        }

                        public Iterable<String> asArguments() {
                            return Arrays.asList(this.val$p.property(NetBeansRunSinglePlugin.RUN_SINGLE_JVM_ARGS).toString().split(" "));
                        }
                    });
                }
                try {
                    je.setStandardInput(System.in);
                }
                catch (RuntimeException ex) {
                    if (LOG.isEnabled(LogLevel.DEBUG)) {
                        LOG.debug("Failed to set STDIN for Plugin: " + je.toString(), (Throwable)ex);
                    }
                    LOG.info("Failed to set STDIN for Plugin: " + je.toString());
                }
                if (project.hasProperty(RUN_SINGLE_CWD)) {
                    je.setWorkingDir((Object)project.property(RUN_SINGLE_CWD).toString());
                }
            });
        });
    }

    private void addTask(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        project.getTasks().register(RUN_SINGLE_TASK, JavaExec.class, je -> {
            String mainClass = project.property(RUN_SINGLE_MAIN).toString();
            if (GRADLE_VERSION.compareTo(GradleVersion.version((String)"6.4")) < 0) {
                je.setMain(mainClass);
            } else {
                je.getMainClass().set((Object)mainClass);
            }
            je.setClasspath(((SourceSet)sourceSets.findByName("main")).getRuntimeClasspath());
            if (project.hasProperty(RUN_SINGLE_ARGS)) {
                je.setArgs(Arrays.asList(project.property(RUN_SINGLE_ARGS).toString().split(" ")));
            }
        });
    }
}

