/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.debug;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.debug.Bundle;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.BreakpointStratifier;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class GroovyBreakpointStratifier
implements BreakpointStratifier {
    public static final String GROOVY_STRATUM = "Groovy";
    private static final Logger LOGGER = Logger.getLogger(GroovyBreakpointStratifier.class.getName());

    public void stratify(JPDABreakpoint breakpoint) {
        LineBreakpoint lb;
        String url;
        FileObject fo;
        if (breakpoint instanceof LineBreakpoint && (fo = GroovyBreakpointStratifier.getFileObjectFromUrl(url = (lb = (LineBreakpoint)breakpoint).getURL())) != null && "text/x-groovy".equals(fo.getMIMEType())) {
            int lineNumber = lb.getLineNumber();
            String groovyName = fo.getNameExt();
            String pt = Bundle.CTL_Default_Print_Text();
            String printText = pt.replace("{groovyName}", groovyName != null ? groovyName : "?");
            String groovyPath = GroovyBreakpointStratifier.getGroovyPath(url, fo);
            lb.setStratum(GROOVY_STRATUM);
            lb.setSourceName(groovyName);
            lb.setSourcePath(groovyPath);
            lb.setPreferredClassName(GroovyBreakpointStratifier.findGroovyClassName(groovyPath, fo, lineNumber));
            lb.setPrintText(printText);
        }
    }

    private static FileObject getFileObjectFromUrl(String url) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fo;
    }

    private static String findGroovyClassName(String relativePath, FileObject fo, final int lineNumber) {
        Source source = Source.create((FileObject)fo);
        final String[] className = new String[]{null};
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    GroovyParserResult result = ASTUtils.getParseResult((Parser.Result)resultIterator.getParserResult());
                    ModuleNode root = ASTUtils.getRoot((ParserResult)result);
                    AstPath path = new AstPath((ASTNode)root, lineNumber, 0);
                    className[0] = ASTUtils.getFqnName((AstPath)path);
                }
            });
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (className[0] != null) {
            return className[0];
        }
        return GroovyBreakpointStratifier.getClassFilter(relativePath);
    }

    private static String getClassFilter(String relativePath) {
        if (relativePath == null) {
            return "";
        }
        int dot = relativePath.lastIndexOf(46);
        if (dot > 0) {
            relativePath = relativePath.substring(0, dot);
        }
        return relativePath.replace('/', '.') + "*";
    }

    private static String getGroovyPath(String url, FileObject fo) {
        if (fo != null) {
            String relativePath;
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp != null) {
                FileObject root = cp.findOwnerRoot(fo);
                relativePath = root != null ? FileUtil.getRelativePath((FileObject)root, (FileObject)fo) : fo.getNameExt();
            } else {
                LOGGER.log(Level.FINE, "No classpath for {0}", url);
                String relativePath2 = fo.getNameExt();
                return relativePath2;
            }
            return relativePath;
        }
        return url;
    }
}

