/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.oracle.bmc.http.signing.internal.Algorithm;
import com.oracle.bmc.http.signing.internal.KeyIdType;
import com.oracle.bmc.http.signing.internal.Version;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public enum SignedRequestVersion implements Version
{
    ONE(1, (Set<Algorithm>)ImmutableSet.of((Object)((Object)Algorithm.RSAPSS256)), (Set<KeyIdType>)ImmutableSet.of((Object)((Object)KeyIdType.REF)), 2048);

    private static final Optional<Version.Error> ABSENT;
    private final int number;
    private final Set<Algorithm> algorithms;
    private final Set<KeyIdType> keyIdTypes;
    private final int minimumKeySize;

    private SignedRequestVersion(int number, Set<Algorithm> algorithms, Set<KeyIdType> keyIdTypes, int minimumKeySize) {
        this.number = number;
        this.algorithms = algorithms;
        this.keyIdTypes = keyIdTypes;
        this.minimumKeySize = minimumKeySize;
    }

    @Override
    public Set<Algorithm> getSupportedAlgorithms() {
        return this.algorithms;
    }

    @Override
    public Set<KeyIdType> getSupportedKeyIdTypes() {
        return this.keyIdTypes;
    }

    @Override
    public int getVersionNumber() {
        return this.number;
    }

    @Override
    public String getVersionName() {
        return String.valueOf(this.getVersionNumber());
    }

    @Override
    public int getMinimumKeySizeInBits() {
        return this.minimumKeySize;
    }

    @Override
    public Optional<Version.Error> validateKeyId(@Nonnull String keyId) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)keyId) ? 1 : 0) != 0);
        boolean isKeyIdValid = false;
        for (KeyIdType idType : this.getSupportedKeyIdTypes()) {
            if (!keyId.matches(idType.getPattern())) continue;
            isKeyIdValid = true;
            break;
        }
        return isKeyIdValid ? ABSENT : Optional.of((Object)((Object)Version.Error.UNSUPPORTED_KEYID));
    }

    @Override
    public Optional<Version.Error> validateAlgorithm(@Nonnull Algorithm algorithm) {
        Preconditions.checkNotNull((Object)((Object)algorithm));
        boolean isAlgorithmValid = this.getSupportedAlgorithms().contains((Object)algorithm);
        return isAlgorithmValid ? ABSENT : Optional.of((Object)((Object)Version.Error.UNSUPPORTED_ALGORITHM));
    }

    @Override
    public Optional<Version.Error> validateKeySize(@Nonnull RSAPublicKey publicKey) {
        int keySize = publicKey.getModulus().bitLength();
        if (keySize < this.getMinimumKeySizeInBits()) {
            return Optional.of((Object)((Object)Version.Error.KEY_TOO_SMALL));
        }
        return ABSENT;
    }

    public static SignedRequestVersion getLatestVersion() {
        return ONE;
    }

    static Optional<SignedRequestVersion> getVersion(@Nonnull String versionNumber) {
        Preconditions.checkNotNull((Object)versionNumber);
        try {
            Integer number = Integer.valueOf(versionNumber.trim());
            for (SignedRequestVersion version : SignedRequestVersion.values()) {
                if (version.getVersionNumber() != number.intValue()) continue;
                return Optional.of((Object)version);
            }
            return Optional.absent();
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }

    static {
        ABSENT = Optional.absent();
    }
}

