/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.google.common.base.Function;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuccessConsumer<REQUEST, RESPONSE>
implements Consumer<Response> {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessConsumer.class);
    private final AsyncHandler<REQUEST, RESPONSE> handler;
    private final Function<Response, RESPONSE> transformer;
    private final REQUEST request;

    @Override
    public void accept(Response response) {
        if (this.handler != null) {
            Object responseWrapper = this.transformer.apply((Object)response);
            this.handler.onSuccess(this.request, responseWrapper);
        } else {
            LOG.debug("Request successful, but no handler configured");
        }
    }

    @ConstructorProperties(value={"handler", "transformer", "request"})
    public SuccessConsumer(AsyncHandler<REQUEST, RESPONSE> handler, Function<Response, RESPONSE> transformer, REQUEST request) {
        this.handler = handler;
        this.transformer = transformer;
        this.request = request;
    }
}

