/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.UIManager;

public final class Utils {
    private Utils() {
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color == null && (color = UIManager.getColor("Table.foreground")) == null) {
            color = new JTable().getForeground();
        }
        sb.append("<font color=\"#");
        String hexColor = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        for (int i = hexColor.length(); i < 6; ++i) {
            sb.append("0");
        }
        sb.append(hexColor);
        sb.append("\">");
        text = text.replace("&", "&amp;");
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        sb.append(text);
        sb.append("</font>");
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static String stringOrNull(String str) {
        if ("null".equals(str)) {
            return null;
        }
        return str;
    }
}

