/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.InputSource;

final class ShareableInputSource
extends InputSource {
    private ByteStream stream;
    private CharacterStream reader;
    private boolean[] initialized = new boolean[2];
    private final InputSource peer;
    private final int bufferSize;
    private static final int BUFFER_SIZE = 0x100007;
    private IOException resetException;

    public static ShareableInputSource create(InputSource peer) {
        if (peer == null) {
            throw new NullPointerException();
        }
        if (peer instanceof ShareableInputSource) {
            return (ShareableInputSource)peer;
        }
        return new ShareableInputSource(peer, 0x100007);
    }

    private ShareableInputSource(InputSource peer, int bufferSize) {
        this.peer = peer;
        this.bufferSize = bufferSize;
    }

    @Override
    public InputStream getByteStream() {
        InputStream in = this.peer.getByteStream();
        if (!this.initialized[1] && in != null) {
            this.stream = new ByteStream(in, this.bufferSize);
            this.stream.mark(this.bufferSize);
            this.initialized[1] = true;
        }
        return this.stream;
    }

    @Override
    public Reader getCharacterStream() {
        Reader in = this.peer.getCharacterStream();
        if (!this.initialized[0] && in != null) {
            this.reader = new CharacterStream(in, this.bufferSize / 2);
            this.initialized[0] = true;
            try {
                this.reader.mark(this.bufferSize / 2);
            }
            catch (IOException ex) {
                this.resetException = ex;
            }
        }
        return this.reader;
    }

    public void reset() throws IOException {
        if (this.resetException != null) {
            throw this.resetException;
        }
        if (this.initialized[1]) {
            this.stream.reset();
        }
        if (this.initialized[0]) {
            this.reader.reset();
        }
    }

    public void closeAll() throws IOException {
        if (this.initialized[1]) {
            this.stream.internalClose();
        }
        if (this.initialized[0]) {
            this.reader.internalClose();
        }
    }

    @Override
    public String getEncoding() {
        return this.peer.getEncoding();
    }

    @Override
    public String getSystemId() {
        return this.peer.getSystemId();
    }

    @Override
    public String getPublicId() {
        return this.peer.getPublicId();
    }

    private static class CharacterStream
    extends BufferedReader {
        public CharacterStream(Reader peer, int buffer) {
            super(peer, buffer);
        }

        @Override
        public void close() throws IOException {
        }

        private void internalClose() throws IOException {
            super.close();
        }
    }

    private static class ByteStream
    extends BufferedInputStream {
        public ByteStream(InputStream peer, int buffer) {
            super(peer, buffer);
        }

        @Override
        public void close() throws IOException {
        }

        private void internalClose() throws IOException {
            super.close();
        }
    }
}

