/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentIdentityRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.netbeans.libs.git.jgit.JGitCredentialsProvider;
import org.netbeans.libs.jsch.agentproxy.ConnectorFactory;

public class JGitSshSessionFactory
extends JschConfigSessionFactory {
    private OpenSshConfig sshConfig;
    private static SshSessionFactory INSTANCE;
    private static final Logger LOG;
    private static final boolean USE_PROXY_TUNNELING;
    private JSch defaultJSch;
    private final Map<String, JSch> byHostName = new HashMap<String, JSch>();

    public static synchronized SshSessionFactory getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JGitSshSessionFactory();
        }
        return INSTANCE;
    }

    protected void configure(OpenSshConfig.Host host, Session sn) {
        sn.setConfig("PreferredAuthentications", "publickey,password,keyboard-interactive");
    }

    public synchronized RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        boolean agentUsed = false;
        String host = uri.getHost();
        JGitCredentialsProvider.IdentityFileItem identityFile = null;
        if (credentialsProvider != null) {
            identityFile = new JGitCredentialsProvider.IdentityFileItem("Identity file for " + host, false);
            if (credentialsProvider.isInteractive() && credentialsProvider.get(uri, new CredentialItem[]{identityFile}) && identityFile.getValue() != null) {
                LOG.log(Level.FINE, "Identity file for {0}: {1}", new Object[]{host, identityFile.getValue()});
                agentUsed = this.setupJSch(fs, host, identityFile, uri, true);
                LOG.log(Level.FINE, "Setting cert auth for {0}, agent={1}", new Object[]{host, agentUsed});
            }
        }
        try {
            LOG.log(Level.FINE, "Trying to connect to {0}, agent={1}", new Object[]{host, agentUsed});
            return super.getSession(uri, credentialsProvider, fs, tms);
        }
        catch (Exception ex) {
            if (agentUsed) {
                LOG.log(ex instanceof TransportException ? Level.FINE : Level.INFO, null, ex);
                this.setupJSch(fs, host, identityFile, uri, false);
                LOG.log(Level.FINE, "Trying to connect to {0}, agent={1}", new Object[]{host, false});
                return super.getSession(uri, credentialsProvider, fs, tms);
            }
            LOG.log(Level.FINE, "Connection failed: {0}", host);
            throw ex;
        }
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        String hostName;
        JSch jsch;
        if (this.defaultJSch == null) {
            this.defaultJSch = this.createDefaultJSch(fs);
            File home = fs.userHome();
            if (home != null) {
                File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
                this.defaultJSch.setKnownHosts(known_hosts.getAbsolutePath());
            }
            this.defaultJSch.removeAllIdentity();
        }
        if ((jsch = this.byHostName.get(hostName = hc.getHostName())) == null) {
            jsch = new JSch();
            jsch.setHostKeyRepository(this.defaultJSch.getHostKeyRepository());
            this.byHostName.put(hostName, jsch);
        }
        return jsch;
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        Session session = super.createSession(hc, user, host, port, fs);
        try {
            List<java.net.Proxy> proxies = ProxySelector.getDefault().select(new URI("socket", null, host, port == -1 ? 22 : port, null, null, null));
            if (proxies.size() > 0) {
                java.net.Proxy p = proxies.iterator().next();
                if (p.type() == Proxy.Type.DIRECT) {
                    session.setProxy(null);
                } else {
                    SocketAddress addr = p.address();
                    if (addr instanceof InetSocketAddress) {
                        InetSocketAddress inetAddr = (InetSocketAddress)addr;
                        String proxyHost = inetAddr.getHostName();
                        int proxyPort = inetAddr.getPort();
                        session.setProxy(this.createProxy(proxyHost, proxyPort));
                    }
                }
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(JGitSshSessionFactory.class.getName()).log(Level.INFO, "Invalid URI: " + host + ":" + port, ex);
        }
        return session;
    }

    private boolean setupJSchIdentityRepository(JSch jsch, String identityFile, boolean preferAgent) throws JSchException {
        AgentIdentityRepository irepo;
        AgentConnector agentConnector;
        boolean agentUsed = false;
        if (preferAgent && (agentConnector = ConnectorFactory.getInstance().createConnector(ConnectorFactory.ConnectorKind.ANY)) != null && (irepo = new AgentIdentityRepository(agentConnector)).getStatus() == 2) {
            jsch.setIdentityRepository((IdentityRepository)irepo);
            agentUsed = true;
        }
        if (!agentUsed) {
            jsch.setIdentityRepository(null);
            jsch.removeAllIdentity();
            jsch.addIdentity(identityFile);
        }
        return agentUsed;
    }

    private boolean setupJSch(FS fs, String host, CredentialItem.StringType identityFile, URIish uri, boolean preferAgent) throws TransportException {
        boolean agentUsed;
        if (this.sshConfig == null) {
            this.sshConfig = OpenSshConfig.get((FS)fs);
        }
        OpenSshConfig.Host hc = this.sshConfig.lookup(host);
        try {
            JSch jsch = this.getJSch(hc, fs);
            agentUsed = this.setupJSchIdentityRepository(jsch, identityFile.getValue(), preferAgent);
        }
        catch (JSchException ex) {
            throw new TransportException(uri, ex.getMessage(), (Throwable)ex);
        }
        return agentUsed;
    }

    private Proxy createProxy(String proxyHost, int proxyPort) {
        return USE_PROXY_TUNNELING ? new ProxyHTTP(proxyHost, proxyPort) : new ProxySOCKS5(proxyHost, proxyPort);
    }

    static {
        if (JSch.getConfig((String)"ssh-rsa") != null && JSch.getConfig((String)"signature.rsa") == null) {
            JSch.setConfig((String)"signature.rsa", (String)JSch.getConfig((String)"ssh-rsa"));
        }
        if (JSch.getConfig((String)"ssh-dss") != null && JSch.getConfig((String)"signature.dss") == null) {
            JSch.setConfig((String)"signature.dss", (String)JSch.getConfig((String)"ssh-dss"));
        }
        LOG = Logger.getLogger(JGitSshSessionFactory.class.getName());
        USE_PROXY_TUNNELING = Boolean.getBoolean("git.lib.proxyHttpTunneling");
    }
}

