/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDbCredentialRequest
extends BmcRequest<Void> {
    private String userId;
    private String dbCredentialId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "dbCredentialId", "opcRequestId", "ifMatch"})
    DeleteDbCredentialRequest(String userId, String dbCredentialId, String opcRequestId, String ifMatch) {
        this.userId = userId;
        this.dbCredentialId = dbCredentialId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).dbCredentialId(this.dbCredentialId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteDbCredentialRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", dbCredentialId=" + this.getDbCredentialId() + ", opcRequestId=" + this.getOpcRequestId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteDbCredentialRequest)) {
            return false;
        }
        DeleteDbCredentialRequest other = (DeleteDbCredentialRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$dbCredentialId = this.getDbCredentialId();
        String other$dbCredentialId = other.getDbCredentialId();
        if (this$dbCredentialId == null ? other$dbCredentialId != null : !this$dbCredentialId.equals(other$dbCredentialId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteDbCredentialRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $dbCredentialId = this.getDbCredentialId();
        result = result * 59 + ($dbCredentialId == null ? 43 : $dbCredentialId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDbCredentialId() {
        return this.dbCredentialId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDbCredentialRequest, Void> {
        private String userId;
        private String dbCredentialId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDbCredentialRequest o) {
            this.userId(o.getUserId());
            this.dbCredentialId(o.getDbCredentialId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDbCredentialRequest build() {
            DeleteDbCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder dbCredentialId(String dbCredentialId) {
            this.dbCredentialId = dbCredentialId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteDbCredentialRequest buildWithoutInvocationCallback() {
            return new DeleteDbCredentialRequest(this.userId, this.dbCredentialId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteDbCredentialRequest.Builder(userId=" + this.userId + ", dbCredentialId=" + this.dbCredentialId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

